//**********************************************************************
//
// Copyright (c) 2012
// PathEngine
// Lyon, France
//
// All Rights Reserved
//
//**********************************************************************

#pragma once

#include "base/interface/iAllocator.h"
#include "base/instrumentation/GlobalAllocator.h"
#include "base/types/Assert.h"
#include <new>

template <class T, typename... tArgs> T*
New(tArgs&&... args)
{
    return new(gAllocator->allocate(sizeof(T))) T(std::forward<tArgs>(args)...);
}

template <class T> void
Delete(T* ptr)
{
    if(ptr)
    {
        ptr->~T();
        gAllocator->deallocate(ptr);
    }
}
template <class T> void
Delete_ConstCast(const T* ptr)
{
    if(ptr)
    {
        T* nonConstPtr = const_cast<T*>(ptr);
        nonConstPtr->~T();
        gAllocator->deallocate(nonConstPtr);
    }
}

//template <typename T> void*
//GetMostDerivedPtr(const T& obj)
//{
//    if constexpr(std::is_polymorphic_v<T>())
//    {
//        return &obj;
//    }
//    return dynamic_cast<void*>(&obj);
//}

template <class T> void
Delete_Virtual(iAllocator& allocator, const T* ptr)
{
    if(ptr)
    {
        T* nonConstPtr = const_cast<T*>(ptr);
        void* mostDerived = nonConstPtr->mostDerivedPtr();
//        void* mostDerived2 = GetMostDerivedPtr(*nonConstPtr);
//        assertR(mostDerived == mostDerived2);
        nonConstPtr->~T();
        gAllocator->deallocate(mostDerived);
    }
}

class iShape;
class iMesh;
class iAgent;
class iCollisionContext;
class iObstacleSet;
class iPath;
class iContentChunk;
class iContentChunkInstance;
class iMeshFederation;
class iSourceTiling;
class iPathEngine;

inline void
Delete(const iShape* ptr)
{
    assertR(false);
}
inline void
Delete(const iMesh* ptr)
{
    assertR(false);
}
inline void
Delete(const iAgent* ptr)
{
    assertR(false);
}
inline void
Delete(const iObstacleSet* ptr)
{
    assertR(false);
}
inline void
Delete(const iPath* ptr)
{
    assertR(false);
}
inline void
Delete(const iContentChunk* ptr)
{
    assertR(false);
}
inline void
Delete(const iContentChunkInstance* ptr)
{
    assertR(false);
}
inline void
Delete(const iMeshFederation* ptr)
{
    assertR(false);
}
inline void
Delete(const iSourceTiling* ptr)
{
    assertR(false);
}

inline void
Delete(iShape* ptr)
{
    assertR(false);
}
inline void
Delete(iMesh* ptr)
{
    assertR(false);
}
inline void
Delete(iAgent* ptr)
{
    assertR(false);
}
inline void
Delete(iCollisionContext* ptr)
{
    assertR(false);
}
inline void
Delete(iObstacleSet* ptr)
{
    assertR(false);
}
inline void
Delete(iPath* ptr)
{
    assertR(false);
}
inline void
Delete(iContentChunk* ptr)
{
    assertR(false);
}
inline void
Delete(iContentChunkInstance* ptr)
{
    assertR(false);
}
inline void
Delete(iMeshFederation* ptr)
{
    assertR(false);
}
inline void
Delete(iSourceTiling* ptr)
{
    assertR(false);
}

inline void
Delete_ConstCast(const iShape* ptr)
{
    assertR(false);
}
inline void
Delete_ConstCast(const iMesh* ptr)
{
    assertR(false);
}
inline void
Delete_ConstCast(const iAgent* ptr)
{
    assertR(false);
}
inline void
Delete_ConstCast(const iCollisionContext* ptr)
{
    assertR(false);
}
inline void
Delete_ConstCast(const iObstacleSet* ptr)
{
    assertR(false);
}
inline void
Delete_ConstCast(const iPath* ptr)
{
    assertR(false);
}
inline void
Delete_ConstCast(const iContentChunk* ptr)
{
    assertR(false);
}
inline void
Delete_ConstCast(const iContentChunkInstance* ptr)
{
    assertR(false);
}
inline void
Delete_ConstCast(const iMeshFederation* ptr)
{
    assertR(false);
}
inline void
Delete_ConstCast(const iSourceTiling* ptr)
{
    assertR(false);
}
