//**********************************************************************
//
// Copyright (c) 2012
// PathEngine
// Lyon, France
//
// All Rights Reserved
//
//**********************************************************************

#pragma once

#include "base/Allocator/ConstructionHelper.h"
#include "base/instrumentation/GlobalAllocator.h"

template <class T>
class cSTLAllocator
{
    using size_type = std::size_t;
public:

    using value_type = T;

    cSTLAllocator() noexcept {}
    template <class T2> cSTLAllocator(const cSTLAllocator<T2>&) noexcept {}

    template <class T2> bool 
    operator==(const cSTLAllocator<T2>&) const noexcept
    {
        return true;
    }
    template <class T2> bool 
    operator!=(const cSTLAllocator<T2>&) const noexcept
    {
        return false;
    }

    T*
    allocate(size_type count) const
    {
        return reinterpret_cast<T*>(gAllocator->allocate(static_cast<uint32_t>(count * sizeof(T))));
    }
    void 
    deallocate(T* ptr, size_type) const noexcept
    {
        gAllocator->deallocate(ptr);
    }
};
