
#pragma once

#include "base/types/TypeTraits.h"
#include <string.h>
#include <utility>

namespace nBufferHelper
{
// buffer management helpers, with specialisations for POD types
    template <class T> void
    constructRange(T* begin, T* end, cPOD_Tag)
    {
    }
    template <class T> void
    constructRange(T* begin, T* end, cNonPOD_Tag)
    {
        while(begin != end)
        {
            ::new((void*)begin) T;
            ++begin;
        }
    }
    template <class T> void
    constructRange(T* begin, T* end)
    {
        constructRange(begin, end, PODType(begin));
    }

    template <class T> void
    deleteRange(T* begin, T* end, cPOD_Tag)
    {
    }
    template <class T> void
    deleteRange(T* begin, T* end, cNonPOD_Tag)
    {
        while(begin != end)
        {
            begin->~T();
            ++begin;
        }
    }
    template <class T> void
    deleteRange(T* begin, T* end)
    {
        deleteRange(begin, end, PODType(begin));
    }

    //template <class T> void
    //copyRange(T* begin, T* end, T* dest, cPOD_Tag)
    //{
       // memcpy(dest, begin, (end - begin) * sizeof(uint32_t));
    //}
    //template <class T> void
    //copyRange(T* begin, T* end, T* dest, cNonPOD_Tag)
    //{
    //    while(begin != end)
    //    {
    //        ::new((void*)dest) T(*begin);
    //        ++begin;
    //        ++dest;
    //    }
    //}
    template <class T> void
    copyRange(T* begin, T* end, T* dest)
    {
        while(begin != end)
        {
            ::new((void*)dest) T(std::move(*begin));
            ++begin;
            ++dest;
        }
        //copyRange(begin, end, dest, PODType(begin));
    }


    template <class T2> inline void
    fillRange(T2* begin, uint32_t size, const T2& fillWith)
    {
        for(uint32_t i = 0; i < size; i++)
        {
            ::new((void*)(begin + i)) T2(fillWith);
        }
    }
    inline void
    fillRange(uint32_t* begin, uint32_t size, const uint32_t& fillWith)
    {
        if(fillWith == 0)
        {
            memset(begin, 0, size * sizeof(uint32_t));
        }
        else
        {
            for(uint32_t i = 0; i < size; i++)
            {
                begin[i] = fillWith;
            }
        }
    }
    inline void
    fillRange(int32_t* begin, uint32_t size, const int32_t& fillWith)
    {
        if(fillWith == 0)
        {
            memset(begin, 0, size * sizeof(int32_t));
        }
        else
        {
            for(uint32_t i = 0; i < size; i++)
            {
                begin[i] = fillWith;
            }
        }
    }
}
