//**********************************************************************
//
// Copyright (c) 2012
// PathEngine
// Lyon, France
//
// All Rights Reserved
//
//**********************************************************************

#include <stdint.h>

#ifndef PATHENGINE_I_ALLOCATOR_DEFINED
#define PATHENGINE_I_ALLOCATOR_DEFINED
class iAllocator
{
public:
    virtual ~iAllocator() {}
    virtual void* allocate(uint32_t size) = 0;
    //virtual void* allocate(uint32_t size, uint32_t& usableSize) = 0;
    virtual void deallocate(void* ptr) = 0;
    virtual void* expand(void* oldPtr, uint32_t oldSize, uint32_t oldSize_Used, uint32_t newSize) = 0;
// helper
    template <class T> void
    allocate_Array(uint32_t arraySize, T*& result)
    {
        result = static_cast<T*>(allocate(sizeof(T) * arraySize));
    }
    //template <class T> void
    //allocate_Array(uint32_t arraySize, uint32_t& usableArraySize, T*& result)
    //{
        //uint32_t usableSize;
        //result = static_cast<T*>(allocate(sizeof(T) * arraySize, usableSize));
        //usableArraySize = usableSize / sizeof(T);
    //}
    template <class T> void
    expand_Array(T*& ptr, uint32_t oldArraySize, uint32_t oldArraySize_Used, uint32_t newArraySize)
    {
        ptr = static_cast<T*>(expand(ptr, sizeof(T) * oldArraySize, sizeof(T) * oldArraySize_Used, sizeof(T) * newArraySize));
    }
};
#endif //ndef PATHENGINE_I_ALLOCATOR_DEFINED
