
#pragma once

#include <cstdint>

// helpers for specialised methods for POD types
struct cPOD_Tag {};
struct cNonPOD_Tag {};
struct cTriviallyCopyable_Tag {};
struct cNonTriviallyCopyable_Tag {};
template <class T>
struct cTypeTraitsHelper
{
    using tPODType = cNonPOD_Tag ;
    using tTriviallyCopyableType = cNonTriviallyCopyable_Tag ;
};
#define DECLARE_POD_TYPE(t) template<> struct cTypeTraitsHelper<t*> { using tPODType = cPOD_Tag ; using tTriviallyCopyableType = cTriviallyCopyable_Tag; };
//...... add other types, as required
DECLARE_POD_TYPE(uint32_t)
DECLARE_POD_TYPE(int32_t)
DECLARE_POD_TYPE(uint64_t)
DECLARE_POD_TYPE(int64_t)
DECLARE_POD_TYPE(uint16_t)
DECLARE_POD_TYPE(int16_t)
DECLARE_POD_TYPE(unsigned char)
DECLARE_POD_TYPE(char)
DECLARE_POD_TYPE(float)
DECLARE_POD_TYPE(bool)
template <class T>
typename cTypeTraitsHelper<T>::tPODType PODType(T&)
{
    return typename cTypeTraitsHelper<T>::tPODType();
}
template <class T>
typename cTypeTraitsHelper<T>::tTriviallyCopyableType TriviallyCopyableType(T&)
{
    return typename cTypeTraitsHelper<T>::tTriviallyCopyableType();
}
