//**********************************************************************
//
// Copyright (c) 2012
// PathEngine
// Lyon, France
//
// All Rights Reserved
//
//**********************************************************************

#pragma once

#include "base/interface/iAllocator.h"
#include "base/types/Assert.h"
#include <stdlib.h>

class cMallocAllocator : public iAllocator
{
public:
    void*
    allocate(uint32_t size)
    {
        assertD(size);
        return malloc(static_cast<size_t>(size));
    }
    void
    deallocate(void* ptr)
    {
        free(ptr);
    }
    void*
    expand(void* oldPtr, uint32_t oldSize, uint32_t oldSize_Used, uint32_t newSize)
    {
        assertD(oldPtr);
        assertD(oldSize);
        assertD(oldSize_Used <= oldSize);
        assertD(newSize > oldSize);
        return realloc(oldPtr, static_cast<size_t>(newSize));
        //assertD(oldPtr);
        //assertD(oldSize);
        //assertD(oldSize_Used <= oldSize);
        //assertD(newSize > oldSize);
        //void* newPtr = malloc(static_cast<size_t>(newSize));
        //memcpy(newPtr, oldPtr, static_cast<size_t>(oldSize_Used));
        //free(oldPtr);
        //return newPtr;
    }
};
