//**********************************************************************
//
// Copyright (c) 2002
// PathEngine
// Lyon, France
//
// All Rights Reserved
//
//**********************************************************************

#include "base/types/Header.h"
#include "common/Geometry/PlueckerLine.h"

cPlueckerLine::cPlueckerLine(const cVector3F& start, const cVector3F& end)
{
    _axis = end - start;
    _product = _axis.crossProduct(start);
}

eSide3D
cPlueckerLine::side3D(const cPlueckerLine& rhs) const
{
    float direction = rhs._product.dotProduct(_axis) + _product.dotProduct(rhs._axis);
    if(direction > 0.0f)
    {
        return S3D_ANTICLOCKWISE;
    }
    if(direction < 0.0f)
    {
        return S3D_CLOCKWISE;
    }
    return S3D_PARALLEL_OR_INTERSECTS;
}

eSide3D
Side3D_Reference(const cVector3F& lhsStart, const cVector3F& lhsEnd, const cVector3F& rhsStart, const cVector3F& rhsEnd)
{
    cVector3F lhsAxis = lhsEnd - lhsStart;
    cVector3F rhsAxis = rhsEnd - rhsStart;
    cVector3F offset = rhsStart;
    offset -= lhsStart;
    cVector3F field = lhsAxis.crossProduct(offset);
    {
        float l = field.lengthSquared();
        if(l == 0.0f)
        {
            return S3D_PARALLEL_OR_INTERSECTS;
        }
    }
    float direction = field.dotProduct(rhsAxis);
    if(direction < 0.0f)
    {
        return S3D_ANTICLOCKWISE;
    }
    if(direction > 0.0f)
    {
        return S3D_CLOCKWISE;
    }
    return S3D_PARALLEL_OR_INTERSECTS;
}
