//**********************************************************************
//
// Copyright (c) 2002
// PathEngine
// Lyon, France
//
// All Rights Reserved
//
//**********************************************************************

#pragma once

#include "base/Geometry/Vector3F.h"

enum eSide3D
{
    S3D_PARALLEL_OR_INTERSECTS,
    S3D_CLOCKWISE,
    S3D_ANTICLOCKWISE,
};

class cPlueckerLine
{
    cVector3F _axis;
    cVector3F _product;

public:

    cPlueckerLine()
    {
    }
    cPlueckerLine(const cVector3F& start, const cVector3F& end);

    eSide3D side3D(const cPlueckerLine& rhs) const;
};

eSide3D
Side3D_Reference(const cVector3F& lhsStart, const cVector3F& lhsEnd, const cVector3F& rhsStart, const cVector3F& rhsEnd);

