//**********************************************************************
//
// Copyright (c) 2013
// PathEngine
// Lyon, France
//
// All Rights Reserved
//
//**********************************************************************

#pragma once

#include <windows.h>

class iThread
{
public:
    virtual ~iThread() {}
    virtual void run() = 0;    
};

inline DWORD WINAPI
ThreadProc(LPVOID threadDataPtr)
{
    iThread* thread = (iThread*)threadDataPtr;
    thread->run();
    return 0;
}

using tThreadHandle = HANDLE;

inline tThreadHandle
StartThread(iThread& thread)
{
    LPVOID threadDataPtr = (LPVOID)(&thread);
    return CreateThread(0, 0, ThreadProc, threadDataPtr, 0, 0);    
}

inline void
JoinThread(tThreadHandle handle)
{
    DWORD result = WaitForSingleObject(handle, INFINITE);
    assertD(result == WAIT_OBJECT_0);
}

inline void
Sleep_Milliseconds(int32_t milliseconds)
{
    Sleep(milliseconds);
}
