
#include "projectCommon/SingleObject/DirectGlobalAllocator.h"
#include "base/types/Header.h"
#include "platform_common/TestbedApplicationEntryPoint.h"
#include "sampleShared/LoadBinary.h"
#include "sampleShared/MeshRenderGeometry.h"
#include "sampleShared/ZoomExtents.h"
#include "sampleShared/CameraControl.h"
#include "common/STL_Helper.h"
#include "externalAPI/i_pathengine.h"
#include <memory>

using std::unique_ptr;

void
TestbedApplicationMain(iPathEngine* pathengine, iTestBed* testBed)
{
// check if interfaces are compatible with the headers used for compilation
    if(testBed->getInterfaceMajorVersion()!=TESTBED_INTERFACE_MAJOR_VERSION
        ||
        testBed->getInterfaceMinorVersion()<TESTBED_INTERFACE_MINOR_VERSION)
    {
        testBed->reportError("Fatal","Testbed version is incompatible with headers used for compilation.");
        return;
    }
    if(pathengine->getInterfaceMajorVersion()!=PATHENGINE_INTERFACE_MAJOR_VERSION
        ||
        pathengine->getInterfaceMinorVersion()<PATHENGINE_INTERFACE_MINOR_VERSION)
    {
        testBed->reportError("Fatal","Pathengine version is incompatible with headers used for compilation.");
        return;
    }
    
    unique_ptr<iMesh> mesh;
    {
        PE::vector<char> buffer;
        LoadBinary("../resource/meshes/mesh1.xml", buffer);
        mesh = pathengine->loadMeshFromBuffer("xml", VectorBuffer(buffer), SizeU(buffer), 0);
    }
    ZoomExtents(*testBed, *mesh);

    cMeshRenderGeometry meshRenderGeometry(*testBed, *mesh);

    bool windowClosed = false;
    while(!testBed->getKeyState("_ESCAPE") && !windowClosed)
    {
        meshRenderGeometry.render(*testBed);
        CameraControl(*testBed);
        testBed->update(20, windowClosed);
    }
}

