#ifndef CLUSTER_MOVEMENT_ORDER_INCLUDED
#define CLUSTER_MOVEMENT_ORDER_INCLUDED

#include "project/testbedApp/CollapsibleGroup/FormationMovementParameters.h"
#include "base/Container/Vector.h"
#include "externalAPI/i_pathengine.h"
#include <memory>

class iAgent;
class iPath;
class iMesh;
class iShape;
class iCollisionContext;
class cColumnTargetsManager;
class cPosition;
class iTestBed;

class cCollapsibleGroupAgent
{
    std::unique_ptr<const iShape> _agentShape;
    int32_t _agentIndex;

    enum eState
    {
        MOVING_TO_START,
        WAITING_FOR_SLOT,
        MOVING_TO_SLOT,
        AT_END,
        FAILED,
    } _state;

    int32_t _toRow, _toColumn;

  // when moving to start only
    std::unique_ptr<iPath> _path;

  // when following base path only
    int32_t _fromRow, _fromColumn;
    double _currentLinkLength, _distanceRemaining;

    static double
    getSpacingRequired(
            cColumnTargetsManager& targetsManager,
            double groupStepDistance,
            int32_t toRow,
            int32_t toColumn
            );

    // returns true if moved
    // advanceDistance is reduced by amount actually advanced
    bool
    advanceStep(
            const iMesh* mesh,
            const iCollisionContext* context,
            cColumnTargetsManager& targetsManager,
            double groupStepDistance,
            double& advanceDistance,
            const cCollapsibleGroupAgent* leader,
            PE::vector<cPosition>& positionsToUpdate
            );

public:

    cCollapsibleGroupAgent(
            const iMesh* mesh,
            const iCollisionContext* context,
            const iShape& agentShape,
            int32_t agentIndex,
            const cPosition& agentStartPosition,
            cColumnTargetsManager& targetsManager,
            int32_t startRow, int32_t startColumn,
            bool& failed_NoPath
            );

    double
    distanceFromFrontRow(
            cColumnTargetsManager& targetsManager,
            double groupStepDistance
            ) const;

    bool
    isInFrontOf(const cCollapsibleGroupAgent& rhsAgent) const;

    // returns true if moved
    bool
    advance(
            const iMesh* mesh,
            const iCollisionContext* context,
            cColumnTargetsManager& targetsManager,
            double groupStepDistance,
            double advanceDistance,
            const cCollapsibleGroupAgent* leader, // don't advance past this leader agent
            PE::vector<cPosition>& positionsToUpdate
            );

    void
    retire();

    void debugDraw(cColumnTargetsManager& targetsManager, iTestBed* testbed, iMesh& mesh) const;
};

class cClusterMovementOrder
{
    const iMesh* _mesh;
    const iCollisionContext* _context;

    cColumnTargetsManager* _targetsManager;
    const cFormationMovementParameters _parameters;
    PE::vector<std::unique_ptr<cCollapsibleGroupAgent>> _agents;

    // prevent copying and assignment
    cClusterMovementOrder(const cClusterMovementOrder&);
    const cClusterMovementOrder& operator=(const cClusterMovementOrder&);

public:

    cClusterMovementOrder(
            const iMesh* mesh,
            const iShape& agentShape,
            const iCollisionContext* context,
            const cFormationMovementParameters& parameters,
            const PE::vector<cPosition>& agentPositions,
            const cPosition& targetPosition,
            int32_t& nextIndex,
            bool& failed_NoPath,            
            PE::vector<int32_t>& indexAssignments
            );
    ~cClusterMovementOrder();

    // returns true if reached end
    bool advance(PE::vector<cPosition>& positionsToUpdate);

    void debugDraw(iTestBed* testbed, iMesh& mesh) const;
};

#endif
