#ifndef COLUMN_TARGETS_MANAGER_INCLUDED
#define COLUMN_TARGETS_MANAGER_INCLUDED

#include "project/testbedApp/CollapsibleGroup/RowTargets.h"
#include <vector>
#include <deque>
#include <memory>

class cColumnTargetsManager
{
    std::unique_ptr<const iMesh> _mesh;
    std::unique_ptr<const iShape> _shape;
    std::unique_ptr<const iCollisionContext> _context;
    std::unique_ptr<iPath> _remainingPath;
    int32_t _agentSpacing, _maximumWidth;
    double _advanceStep;
    cPosition _currentSegmentEnd;
    int32_t _currentSegmentForwardX, _currentSegmentForwardY;
    std::deque<cRowTargets> _targetsWindow;
    int32_t _startIndex;
    bool _atEnd;
    double _frontRowDistance;

    // prevent copying and assignment
    cColumnTargetsManager(const cColumnTargetsManager&);
    const cColumnTargetsManager& operator=(const cColumnTargetsManager&);

public:

    cColumnTargetsManager(
            std::unique_ptr<const iMesh> mesh,
            std::unique_ptr<const iShape> shape,
            std::unique_ptr<const iCollisionContext> context,
            std::unique_ptr<iPath> path,
            int32_t agentSpacing, int32_t maximumWidth,
            double advanceStep
            );

    bool atEnd() const;
    int32_t pushFront(); // returns index of added row
    void popBack(int32_t rowIndex);
    cRowTargets& refRow(int32_t rowIndex);

    int32_t frontRowIndex() const;
    double frontRowDistance() const;
};

#endif
