#ifndef FORMATION_MOVEMENT_ORDER_INCLUDED
#define FORMATION_MOVEMENT_ORDER_INCLUDED

#include "base/Container/Vector.h"

class iAgent;
class iMesh;
class iShape;
class iCollisionContext;
class cPosition;
class iTestBed;
class cClusterMovementOrder;
class cFormationMovementParameters;

class cFormationMovementOrder
{
    PE::vector<cClusterMovementOrder*> _clusterOrders;
    PE::vector<cPosition> _currentPositions;

    // prevent copying and assignment
    cFormationMovementOrder(const cFormationMovementOrder&);
    const cFormationMovementOrder& operator=(const cFormationMovementOrder&);

public:

    cFormationMovementOrder(
            const iMesh* mesh,
            const iShape& agentShape,
            const iCollisionContext* context,
            const cFormationMovementParameters& parameters,
            const PE::vector<cPosition>& agentStartPositions,
            const cPosition& targetPosition,
            PE::vector<int32_t>& agentIndexAssignments // per agent in order, for querying position, -1 indicates agent cannot reach target
            );
    ~cFormationMovementOrder();

    // returns true if reached end
    bool advance();

    cPosition getCurrentPosition(int32_t agentIndex) const;

    void debugDraw(iTestBed* testbed, iMesh& mesh) const;
};

#endif
