#include "base/types/Header.h"
#include "project/testbedApp/CollapsibleGroup/GenerateColumnTargets.h"
#include "sampleShared/IntegerPoint2D.h"
#include "externalAPI/i_pathengine.h"
#include <vector>
#include <math.h>

static void
NormaliseToDoubles(const cIntegerPoint2D& v, double& x, double& y)
{
    // (convert to double before multiply)
    x = v.getX();
    y = v.getY();
    double lengthSquared = x * x + y * y;
    double length = sqrt(lengthSquared);
    x /= length;
    y /= length;
}

static void
GenerateColumnTargets(
        const iMesh& mesh, 
        const iShape& agentShape, 
        const iCollisionContext* context,
        const cPosition& basePosition,
        const cIntegerPoint2D& incrementDirection,
        int32_t spacing,
        int32_t maximumWidth,
        PE::vector<cPosition>& targets
        )
{
    double incrementX, incrementY;
    NormaliseToDoubles(incrementDirection, incrementX, incrementY);
    incrementX *= spacing;
    incrementY *= spacing;
    targets.clear();
    int32_t i;
    double x = basePosition.x;
    double y = basePosition.y;
    for(i = 1; i <= maximumWidth - 1 / 2; ++i)
    {
        x += incrementX;
        y += incrementY;
        cPosition p;
        p.x = static_cast<int32_t>(x);
        p.y = static_cast<int32_t>(y);
        if(mesh.testLineCollision_XY(agentShape, context, basePosition, p.x, p.y, p.cell))
        {
            return;
        }
        targets.push_back(p);
    }
}

void
GenerateColumnTargets(
        const iMesh& mesh, 
        const iShape& agentShape, 
        const iCollisionContext* context,
        const cPosition& basePosition,
        int32_t forwardVectorX, int32_t forwardVectorY,
        int32_t spacing,
        int32_t maximumWidth,
        PE::vector<cPosition>& leftTargets,
        PE::vector<cPosition>& rightTargets
        )
{
    assertD(maximumWidth > 0);
    cIntegerPoint2D forwardVector(forwardVectorX, forwardVectorY);
    GenerateColumnTargets(mesh, agentShape, context, basePosition, forwardVector.left90(), spacing, maximumWidth, leftTargets);
    GenerateColumnTargets(mesh, agentShape, context, basePosition, forwardVector.right90(), spacing, maximumWidth, rightTargets);
}
