#include "base/types/Header.h"
#include "project/testbedApp/CollapsibleGroup/GetGroupRootPosition.h"
#include "externalAPI/i_pathengine.h"

static double
DistanceSquared(const cPosition& p, double x, double y)
{
    return (x - p.x) * (x - p.x) + (y - p.y) * (y - p.y);
}

void
GetGroupRootPosition(
        const PE::vector<cPosition>& groupPositions,
        cPosition& result
        )
{
    assertD(!groupPositions.empty());

  // get average X,Y
    double averageX, averageY;
    averageX = groupPositions[0].x;
    averageY = groupPositions[0].y;
    int32_t i;
    for(i = 1; i != groupPositions.size(); ++i)
    {
        averageX += groupPositions[i].x;
        averageY += groupPositions[i].y;
    }
    averageX /= groupPositions.size();
    averageY /= groupPositions.size();
    int32_t averageX32, averageY32;
    averageX32 = static_cast<int32_t>(averageX);
    averageY32 = static_cast<int32_t>(averageY);

  // find agent closest to centre
  // (this agent's ground position will then be used to root the group in the mesh)
    int32_t closestI = 0;
    double closestD = DistanceSquared(groupPositions[0], averageX, averageY);
    for(i = 1; i != groupPositions.size(); ++i)
    {
        double candidateD = DistanceSquared(groupPositions[i], averageX, averageY);
        if(candidateD < closestD)
        {
            closestI = i;
            closestD = candidateD;
        }
    }

    // using the position of the agent closest to centre, directly, guarantees that at least one agent should be able to reach this position
    result = groupPositions[closestI];
}
