#include "base/types/Header.h"
#include "project/testbedApp/CollapsibleGroup/RowTargets.h"
#include "externalAPI/i_pathengine.h"

cRowTargets::cRowTargets(
        const PE::vector<cPosition>& leftTargets,
        const cPosition& basePosition,
        const PE::vector<cPosition>& rightTargets
        ) :
 _positions(SizeL(leftTargets) + 1 + SizeL(rightTargets)),
 _assigned(SizeL(_positions), (const cCollapsibleGroupAgent*)0) // ** cast added here to work around strange compile error with clang choosing vector copy region constructor
{
    _centreI = SizeL(leftTargets);
    int32_t i;
    for(i = 0; i != SizeL(leftTargets); ++i)
    {
        _positions[_centreI - 1 - i] = leftTargets[i];
    }
    _positions[_centreI] = basePosition;
    for(i = 0; i != SizeL(rightTargets); ++i)
    {
        _positions[_centreI + 1 + i] = rightTargets[i];
    }
}

int32_t
cRowTargets::firstColumn() const
{
    return -_centreI;
}
int32_t
cRowTargets::lastColumn() const
{
    return SizeL(_positions) - 1 - _centreI;
}
bool
cRowTargets::isValidColumn(int32_t targetColumn) const
{
    return targetColumn >= firstColumn() && targetColumn <= lastColumn();
}

const cPosition&
cRowTargets::position(int32_t column) const
{
    assertD(isValidColumn(column));
    return _positions[column + _centreI];
}
bool
cRowTargets::isAssigned(int32_t column) const
{
    assertD(isValidColumn(column));
    return _assigned[column + _centreI] != 0;
}
void
cRowTargets::assign(int32_t column, const cCollapsibleGroupAgent* agent)
{
    assertD(isValidColumn(column));
    assertD(_assigned[column + _centreI] == 0);
    _assigned[column + _centreI] = agent;
}
void
cRowTargets::unassign(int32_t column, const cCollapsibleGroupAgent* agent)
{
    assertD(isValidColumn(column));
    assertD(_assigned[column + _centreI] == agent);
    _assigned[column + _centreI] = 0;
}
const cCollapsibleGroupAgent*
cRowTargets::assignedAgent(int32_t column)
{
    return _assigned[column + _centreI];
}

int32_t
cRowTargets::closestValidColumn(int32_t targetColumn) const
{
    if(targetColumn < firstColumn())
    {
        return firstColumn();
    }
    if(targetColumn > lastColumn())
    {
        return lastColumn();
    }
    return targetColumn;
}

int32_t
cRowTargets::centringAndWidthAreIdentical(const cRowTargets& rhsTargets) const
{
    return _centreI == rhsTargets._centreI && _positions.size() == rhsTargets._positions.size();
}
