#ifndef ROW_TARGETS_INCLUDED
#define ROW_TARGETS_INCLUDED

#include "externalAPI/i_pathengine.h"
#include "base/Container/Vector.h"

class cCollapsibleGroupAgent;

class cRowTargets
{
    PE::vector<cPosition> _positions;
    PE::vector<const cCollapsibleGroupAgent*> _assigned;
    int32_t _centreI;

public:

    cRowTargets(
        const PE::vector<cPosition>& leftTargets,
        const cPosition& basePosition,
        const PE::vector<cPosition>& rightTargets
        );

    int32_t firstColumn() const;
    int32_t lastColumn() const;
    bool isValidColumn(int32_t targetColumn) const;
    const cPosition& position(int32_t column) const;
    bool isAssigned(int32_t column) const;
    void assign(int32_t column, const cCollapsibleGroupAgent* agent);
    void unassign(int32_t column, const cCollapsibleGroupAgent* agent);
    const cCollapsibleGroupAgent* assignedAgent(int32_t column);

    int32_t closestValidColumn(int32_t targetColumn) const;

    int32_t centringAndWidthAreIdentical(const cRowTargets& rhsTargets) const;
};

#endif
