
#include "base/types/Header.h"
#include "project/testbedApp/MeshFederation/BuildFederation_FromWorldMesh.h"
#include "sampleShared/LoadBinary.h"
#include "common/STL_Helper.h"
#include "common/FileOutputStream.h"
#include "externalAPI/i_pathengine.h"
#include <sstream>
#include <memory>

using std::unique_ptr;

namespace
{

class cSaveTileMeshesCallBack : public iMeshFederationTileGeneratedCallBack
{
    iTestBed* _testBed;

public:

    cSaveTileMeshesCallBack(iTestBed* testBed);
    void tileGenerated(int32_t tileIndex, iMesh* tileMesh);
};

} // end anonymous namespace

cSaveTileMeshesCallBack::cSaveTileMeshesCallBack(iTestBed* testBed) :
 _testBed(testBed)
{
}

void
cSaveTileMeshesCallBack::tileGenerated(int32_t tileIndex, iMesh* tileMesh)
{
    std::ostringstream fileName;
    fileName << "federationTile" << tileIndex << ".tok";
    cFileOutputStream fos(fileName.str().c_str());
    tileMesh->saveGround("tok", true, fos);
    delete tileMesh;
    _testBed->printTextLine(5, fileName.str().c_str());
    _testBed->printTextLine(5, "finished generating federation tile:");
    _testBed->printTextLine(5, "Generating Federation Tile Meshes");
    bool windowClosed;
    _testBed->update(20, windowClosed);
    if(windowClosed)
        exit(0);
}

static void
BuildFederation(
        iPathEngine* pathEngine, iTestBed* testBed,
        iMesh& worldMesh,
        int32_t tileStep, int32_t overlap
        )
{
    cSaveTileMeshesCallBack callback(testBed);

    auto federation = pathEngine->buildMeshFederation_FromWorldMesh(
            worldMesh,
            tileStep, overlap,
            callback
            );

    std::ostringstream fileName;
    fileName << "federation.tok";
    cFileOutputStream fos(fileName.str().c_str());
    federation->save("tok", fos);
}

void
BuildFederation_FromWorldMesh(
        iPathEngine* pathEngine, iTestBed* testBed,
        const char* worldMeshName,
        int32_t tileStep, int32_t overlap
        )
{
    std::string meshPath = "../resource/meshes/";
    meshPath.append(worldMeshName);
    meshPath.append(".tok");
    PE::vector<char> buffer;
    LoadBinary(meshPath.c_str(), buffer);
    if(buffer.empty())
        Error("Fatal", "Failed to load world mesh file.");
    auto worldMesh = pathEngine->loadMeshFromBuffer("tok", VectorBuffer(buffer), SizeU(buffer), 0);
    if(!worldMesh)
        Error("Fatal", "No ground tris in world mesh.");
    BuildFederation(pathEngine, testBed, *worldMesh, tileStep, overlap);
}
