
#include "base/types/Header.h"
#include "project/testbedApp/MeshFederation/BuildFederation_TileByTile3DCP.h"
#include "sampleShared/SimpleDOM.h"
#include "sampleShared/LoadBinary.h"
#include "common/FileOutputStream.h"
#include "common/STL_Helper.h"
#include "externalAPI/i_pathengine.h"
#include <string>
#include <fstream>
#include <sstream>

using PE::vector;
using std::unique_ptr;

static void
BuildTile(
        iTestBed* testBed,
        iMeshFederation& federation,
        int32_t tileIndex,
        const iSourceTiling& tiling,
        const vector<unique_ptr<const iGround>>& sourceTiles
        )
{
    cVectorReceiver<int32_t> tileIndicesReceiver;
    federation.getGroundTilesOverlapped(tileIndex, tiling, tileIndicesReceiver);
    const auto& tileIndices = tileIndicesReceiver.vector;
    int32_t numberOfTiles = SizeL(tileIndices);
    vector<const iGround*> tileGround(numberOfTiles);
    for(int32_t i = 0; i != numberOfTiles; ++i)
        tileGround[i] = sourceTiles[tileIndices[i]].get();
    auto tileMesh = federation.buildTileMeshFromLocalGroundTiles_IGround(
            tileIndex, tiling,
            &tileGround[0], numberOfTiles,
            0
            );
    std::ostringstream fileName;
    fileName << "federationTile" << tileIndex << ".tok";
    cFileOutputStream fos(fileName.str().c_str());
    if(tileMesh)
    {
        tileMesh->saveGround("tok", true, fos);
    }
    testBed->printTextLine(5, fileName.str().c_str());
    testBed->printTextLine(5, "finished generating federation tile:");
    testBed->printTextLine(5, "Generating Federation Tile Meshes");
    bool windowClosed;
    testBed->update(20, windowClosed);
    if(windowClosed)
        exit(0);
}

void
LoadAllSourceTiles(
        iPathEngine* pathEngine,
        int32_t numberToLoad,
        vector<unique_ptr<const iGround>>& result
        )
{
    for(int32_t i = 0; i != numberToLoad; ++i)
    {
        std::string meshName;
        {
            std::ostringstream oss;
            oss << "../tileGround" << i << ".tok";
            meshName = oss.str();
        }
        vector<char> meshBuffer;
        LoadBinary(meshName.c_str(), meshBuffer);
        if(meshBuffer.empty())
        {
            result.push_back(nullptr);
        }
        else
        {
            result.push_back(pathEngine->loadGroundFromBuffer(
                "tok",
                VectorBuffer(meshBuffer), SizeL(meshBuffer),
                0
            ));
        }
    }
}

void
BuildFederation_TileByTile3DCP(
        iPathEngine* pathEngine, iTestBed* testBed,
        int32_t tileSize, int32_t overlap
        )
{
    unique_ptr<iSourceTiling> tiling;
    if(!FileExists("tiling.tok"))
    {
        Error("Fatal", "Tiling file not found. Please run the 3D content processing first to generated the necessary tiling and tiled ground result pieces.");
    }
    {
        vector<char> tilingBuffer;
        LoadBinary("tiling.tok", tilingBuffer);
        tiling = pathEngine->loadSourceTiling("tok", VectorBuffer(tilingBuffer), SizeL(tilingBuffer));
    }

    vector<unique_ptr<const iGround>> sourceTiles;
    LoadAllSourceTiles(pathEngine, tiling->size(), sourceTiles);

    cHorizontalRange worldRange;
    tiling->getWorldRange(worldRange);

    auto federation = pathEngine->buildMeshFederation_TilingOnly(worldRange, tileSize, overlap);

    for(int32_t i = 0; i != federation->size(); ++i)
    {
        BuildTile(testBed, *federation, i, *tiling, sourceTiles);
    }

    std::ostringstream fileName;
    fileName << "federation.tok";
    cFileOutputStream fos(fileName.str().c_str());
    federation->save("tok", fos);
}

