
#include "projectCommon/SingleObject/DirectGlobalAllocator.h"
#include "base/types/Header.h"
#include "base/types/Error.h"
#include "sampleShared/GenerateAndSaveRandomSeed.h"
#include "sampleShared/LoadBinary.h"
#include "sampleShared/MeshRenderGeometry.h"
#include "sampleShared/AgentRenderGeometry.h"
#include "sampleShared/ZoomExtents.h"
#include "sampleShared/PathStressSetup.h"
#include "sampleShared/RunPathStressWithConfig.h"
#include "sampleShared/Error.h"
#include "common/STL_Helper.h"
#include "base/Container/Vector.h"
#include "platform_common/TestbedApplicationEntryPoint.h"
#include "externalAPI/i_pathengine.h"
#include <string>
#include <memory>

using std::unique_ptr;
using PE::vector;

namespace
{

class cVisualisationCallBack : public iPathStressVisualisationCallBack
{
    iTestBed& _testBed;
    unique_ptr<iRenderGeometry> _contextGeometry;
    unique_ptr<cMeshRenderGeometry> _meshRenderGeometry;
public:
    cVisualisationCallBack(iTestBed& testBed) :
        _testBed(testBed)
    {
    }
    void newMesh(const iMesh& mesh, bool firstIteration)
    {
        if(firstIteration)
            ZoomExtents(_testBed, mesh);
        _meshRenderGeometry = std::make_unique<cMeshRenderGeometry>(_testBed, mesh);
    }
    void newDynamicObstacleSet(const iCollisionContext& context)
    {
        _contextGeometry = _testBed.newRenderGeometry();
        for(int32_t i = 0; i < context.getNumberOfAgents(); i++)
        {
            cAgentRenderGeometry::AddCylinder(context.refAgent(i), 40, *_contextGeometry);
        }
    }
    void renderMeshAndContext() const
    {
        _meshRenderGeometry->render(_testBed),
        _testBed.setColour("orange");
        _testBed.render(*_contextGeometry);
    }
    void renderPath(const iPath& path) const
    {
        _testBed.setColour("green");
        cMeshRenderGeometry::DrawPath(_testBed, path);
    }
    void update() const
    {
        bool windowClosed;
        _testBed.update(20, windowClosed);
        if(windowClosed)
            exit(0);
    }
};

} // anonymous namespace

void
TestbedApplicationMain(iPathEngine* pathEngine, iTestBed *testbed)
{
    // check if interfaces are compatible with the headers used for compilation
    if(testbed->getInterfaceMajorVersion() != TESTBED_INTERFACE_MAJOR_VERSION
        ||
        testbed->getInterfaceMinorVersion() < TESTBED_INTERFACE_MINOR_VERSION)
    {
        testbed->reportError("Fatal", "Testbed version is incompatible with headers used for compilation.");
        return;
    }
    if(pathEngine->getInterfaceMajorVersion() != PATHENGINE_INTERFACE_MAJOR_VERSION
        ||
        pathEngine->getInterfaceMinorVersion() < PATHENGINE_INTERFACE_MINOR_VERSION)
    {
        testbed->reportError("Fatal", "Pathengine version is incompatible with headers used for compilation.");
        return;
    }

    cPathStressSetup setup(*pathEngine);
    cVisualisationCallBack callBack(*testbed);

    // ****
    // A random seed will be generated and saved to the file 'savedRandomSeed.txt',
    // in the bin directory of the release.
    // If an assertR fails, or if PathEngine crashes or hangs, please report this value.

    //{
    //    uint32_t seed = 3559967199;
    //    setup.runStressTest(*pathEngine, static_cast<int32_t>(seed), 6, &callBack);
    //    exit(1);
    //}

    do
    {
        uint32_t seed = GenerateAndSaveRandomSeed();

        for(int32_t expansion = 0; expansion < setup.numberOfExpansions(); ++expansion)
            setup.runStressTest(*pathEngine, static_cast<int32_t>(seed), expansion, &callBack);

    } while(!testbed->getKeyState("_ESCAPE"));
}
