#include "projectCommon/SingleObject/DirectGlobalAllocator.h"
#include "base/types/Header.h"
#define extern
#include "project/testbedApp/PlayableDemo/Globals.h"
#undef extern
#include "project/testbedApp/PlayableDemo/Resources.h"
#include "project/testbedApp/PlayableDemo/GameState.h"
#include "project/testbedApp/PlayableDemo/GameObject.h"
#include "sampleShared/MoveAgent.h"
#include "sampleShared/Error.h"
#include "sampleShared/SimpleDOM.h"
#include "sampleShared/LoadWhiteSpaceDelimited.h"
#include "sampleShared/LoadBinary.h"
#include "sampleShared/LoadBinary.h"
#include "base/Container/Vector.h"
#include "common/STL_Helper.h"
#include "platform_common/TestbedApplicationEntryPoint.h"
#include "externalAPI/i_pathengine.h"
#include <math.h>
#include <string.h>
#include <fstream>

using PE::vector;
using std::string;

void
LoadSounds(const cSimpleDOM& sounds)
{
    string pathToSounds = "../resource/sounds/";
    for(uint32_t i = 0; i < sounds._children.size(); i++)
    {
        const cSimpleDOM& sound = sounds._children[i];
        if(sound._name != "sound")
        {
            continue;
        }
        string fileName = pathToSounds;
        fileName += sound.getAttribute("name");
        int32_t buffers = sound.attributeAsLongWithDefault("buffers", 4);
        vector<char> fileBuffer;
        LoadBinary(fileName.c_str(), fileBuffer);
        if(fileBuffer.empty())
        {
            const char* attributes[3];
            attributes[0] = "file_name";
            attributes[1] = fileName.c_str();
            attributes[2] = 0;
            Error("Fatal", "Failed to load sound file.", attributes);
        }
        int32_t index = gTestBed->createSound(VectorBuffer(fileBuffer), SizeU(fileBuffer), buffers);
        if(index == -1)
        {
            const char* attributes[3];
            attributes[0] = "file_name";
            attributes[1] = fileName.c_str();
            attributes[2] = 0;
            Error("Fatal", "Could not create sound from file.", attributes);
        }
    }
}

string
PlayLevel(const cSimpleDOM& templates, const cSimpleDOM& script, bool onLastLevel)
{
    {
        bool windowClosed;
        gTestBed->update(20, windowClosed);
        if(windowClosed)
            exit(0);
    }

    new cGameState(templates, script); // assigns self to gGameState in constructor

    int32_t i = script.firstChildWithName("initialisation");
    if(i >= 0)
    {
        const cSimpleDOM& initialisationScript = script._children[i];
        for(uint32_t j = 0; j < initialisationScript._children.size(); j++)
        {
            gGameState->execute(initialisationScript._children[j]);
        }
    }

    string result;
    while(!gGameState->levelCompleted(result))
    {
        gGameState->draw();

      // tell the testbed to render this frame

        {
            bool windowClosed;
            gTestBed->update(40, windowClosed);
            if(windowClosed)
                exit(0);
        }

        static bool paused = false;
        if(gTestBed->getKeyState("P"))
        {
            paused = gTestBed->getKeyState("_RSHIFT");
        }

        if(!paused)
        {
            gGameState->update();
        }

    }

    bool exitFlag = false;
    do
    {
        if(result == "win")
        {
            if(onLastLevel)
            {
                gTestBed->displaySplashImage_Centred(cResources::SPLASH_ALLCOMPLETE);
            }
            else
            {
                gTestBed->displaySplashImage_Centred(cResources::SPLASH_LEVELCOMPLETE);
            }
        }
        else
        {
            gTestBed->displaySplashImage_Centred(cResources::SPLASH_DIED);
        }

        gGameState->draw();

        {
            bool windowClosed;
            gTestBed->update(20, windowClosed);
            if(windowClosed)
            {
                exitFlag = true;
                result = "exit";
            }
        }
        const char* keyPressed;
        while(keyPressed = gTestBed->receiveKeyMessage())
        {
            if(!strcmp("d_SPACE", keyPressed))
            {
                exitFlag = true;
            }
            else if(!strcmp("d_ESCAPE", keyPressed))
            {
                exitFlag = true;
                result = "exit";
            }
        }
    }
    while(!exitFlag);

    delete gGameState;
    gGameState = 0;
    return result;
}

void
TestbedApplicationMain(iPathEngine* pathEngine, iTestBed* testBed)
{
// check if interfaces are compatible with the headers used for compilation
    if(testBed->getInterfaceMajorVersion()!=TESTBED_INTERFACE_MAJOR_VERSION
        ||
        testBed->getInterfaceMinorVersion()<TESTBED_INTERFACE_MINOR_VERSION)
    {
        testBed->reportError("Fatal","Testbed version is incompatible with headers used for compilation.");
        return;
    }
    if(pathEngine->getInterfaceMajorVersion()!=PATHENGINE_INTERFACE_MAJOR_VERSION
        ||
        pathEngine->getInterfaceMinorVersion()<PATHENGINE_INTERFACE_MINOR_VERSION)
    {
        testBed->reportError("Fatal","Pathengine version is incompatible with headers used for compilation.");
        return;
    }


    gPathEngine = pathEngine;
    gTestBed = testBed;

    cSimpleDOM script;
    {
        std::ifstream is("../resource/scripts/demo_script.txt");
        if(!is.good())
        {
            Error("Fatal", "Could not open demo script ('resource/scripts/demo_script.txt').");
        }
        LoadWhiteSpaceDelimited(is, script);
    }
    assertR(script._name == "script");

    int32_t child = script.firstChildWithName("sounds");
    if(child >= 0)
    {
        LoadSounds(script._children[child]);
    }

    cResources resources(script.refFirstChildWithName("shapes"));
    gResources = &resources;

    cSimpleDOM& templates = script.refFirstChildWithName("templates");
    cSimpleDOM& levels = script.refFirstChildWithName("levels");

    assertR(!levels._children.empty());

    {

        bool pressedSpace = false;
        do
        {
            gTestBed->displaySplashImage_Centred(cResources::SPLASH_BEGIN);
            {
                bool windowClosed;
                gTestBed->update(20, windowClosed);
                if(windowClosed)
                    exit(0);
            }
            const char* keyPressed;
            while(keyPressed = gTestBed->receiveKeyMessage())
            {
                if(!strcmp("d_SPACE", keyPressed))
                {
                    pressedSpace = true;
                }
            }
        }
        while(!pressedSpace);
    }

    uint32_t i = 0;
    while(1)
    {
        bool onLastLevel = (i + 1 == levels._children.size());
        string result = PlayLevel(templates, levels._children[i], onLastLevel);
        if(result == "exit")
        {
            break;
        }
        if(result == "win")
        {
            i++;
            if(onLastLevel)
            {
                i = 0;
            }
        }
    }
}
