#include "base/types/Header.h"
#include "project/testbedApp/PlayableDemo/BoundedBehaviour.h"
#include "project/testbedApp/PlayableDemo/GameState.h"
#include "project/testbedApp/PlayableDemo/GameObject.h"
#include "project/testbedApp/PlayableDemo/Globals.h"
#include "sampleShared/SimpleDOM.h"

cBoundedBehaviour::cBoundedBehaviour(const cSimpleDOM& element, cGameObject& controlledObject)
{
    _base = iBehaviour::create(element.refFirstChildWithName("base"), controlledObject);
    for(uint32_t i = 0; i < element._children.size(); ++i)
    {
        const cSimpleDOM& child = element._children[i];
        if(child._name == "bound")
        {
            std::string targetName = child.getAttribute("object");
            _bounds.push_back(gGameState->findObject(targetName)->refAgent().addExternalRef());
        }
    }
}
cBoundedBehaviour::~cBoundedBehaviour()
{
    delete _base;
}

bool
cBoundedBehaviour::update(cGameObject& controlledObject)
{
// the bound agents are assumed to not already be included in the obstructions context
// i.e. these should be markers or something like that
    int32_t i;
    for(i = 0; i < static_cast<int32_t>(_bounds.size()); ++i)
    {
        gGameState->refObstructionsContext().addAgent(*_bounds[i]);
    }
    bool result = _base->update(controlledObject);
    for(i = 0; i < static_cast<int32_t>(_bounds.size()); ++i)
    {
        gGameState->refObstructionsContext().removeAgent(*_bounds[i]);
    }
    return result;
}
