
#include "sampleShared/MeshLOSPreprocess.h"
#include "externalAPI/i_pathengine.h"
#include <vector>
#include <string>
#include <map>
class iAgent;
class iMesh;
class iShape;
class iCollisionContext;
class cGameObject;
class cSimpleDOM;

class cGameState
{
    const cSimpleDOM* _frameScript;
    std::unique_ptr<iMesh> _mesh;
    std::unique_ptr<iRenderGeometry> _meshTris;
    std::unique_ptr<iRenderGeometry> _meshEdges;
    std::unique_ptr<cMeshLOSPreprocess> _losPreprocess;
    PE::vector<cGameObject*> _objects;
    std::unique_ptr<iCollisionContext> _obstructionsContext;
    std::unique_ptr<iCollisionContext> _switchesContext;
    std::unique_ptr<iCollisionContext> _collisionCheckersContext;
    std::map<std::string, int32_t> _flags;
    float _cameraDistance;
    float _cameraHeading;
    float _cameraElevation;
    bool _lookAtActive;
    bool _endLevel;
    std::string _result;

    cGameObject* resolveObjectArgument(const cSimpleDOM& command) const;
    void updateCollisionFor(cGameObject& object);

public:

    cGameState(const cSimpleDOM& templates, const cSimpleDOM& levelScript);
    ~cGameState();

  // accessors
    iMesh& refMesh() const {return *_mesh;}
    iCollisionContext& refObstructionsContext() const {return *_obstructionsContext;}
    iCollisionContext& refCollisionCheckersContext() const {return *_collisionCheckersContext;}
    float getCameraHeading() const {return _cameraHeading;}

    bool uiControlIsFrozen() const {return _lookAtActive;}

    uint32_t numberOfObjects() const {return static_cast<uint32_t>(_objects.size());}
    cGameObject* findObject(const std::string& contentName) const;
    void findAllObjectsWithType(const std::string& type, PE::vector<cGameObject*>& result) const;

    void update();
    void draw();
    cPosition positionAtMouse() const;

    bool levelCompleted(std::string& result);

    void execute(const cSimpleDOM& command);
    bool evaluate(const cSimpleDOM& expression);
};
