
#include "project/testbedApp/PlayableDemo/iBehaviour.h"
#include "project/testbedApp/PlayableDemo/Queueing.h"
#include "base/Container/Vector.h"
#include "externalAPI/i_pathengine.h"
#include <memory>

class cSimpleDOM;
class cGameObject;
class iPath;
class iCollisionContext;
class iAgent;

class cPackHunterBehaviour : public iBehaviour
{
    static cQueueManager _queueManager;
    static int32_t _timeSincePathToGoal;
    static PE::vector<cPosition> _interceptPositions;

    cGameObject& _controlledObject;
    cQueueEntry _queueEntry;
    std::unique_ptr<iPath> _currentPath;
    int32_t _timeSincePathQuery;

    bool _debugDisplay;

public:

    cPackHunterBehaviour(const cSimpleDOM& element, cGameObject& controlledObject);
    ~cPackHunterBehaviour();

// interface for iController

    bool update(cGameObject& controlledObject);

    void draw(cGameObject& controlledObject);
};
