#include "base/types/Header.h"
#include "project/testbedApp/PlayableDemo/PathFrequency.h"
#include "project/testbedApp/PlayableDemo/GameObject.h"
#include "externalAPI/i_pathengine.h"

int32_t
GetPathFrequency(const cGameObject& controlledObject, const cGameObject& targetObject)
{
    int32_t distance = static_cast<int32_t>(controlledObject.distanceTo(targetObject));
    if(distance <= 100)
    {
        // pathfind every frame at close range
        return 1;
    }
    int32_t result = distance - 100;
    result /= 8;
    if(result > 50)
    {
        // maximum time between paths
        result = 50;
    }
    return result;
}

int32_t
GetPathFrequency(const iPath& currentPath)
{
    uint32_t length = currentPath.getLength();
    if(length <= 200)
    {
        // pathfind every frame at close range
        return 1;
    }
    length -= 100;
    if(length > 4000)
    {
        length = 4000;
    }
    return static_cast<int32_t>(length) / 15;
}
