#include "base/types/Header.h"
#include "project/testbedApp/PlayableDemo/Queueing.h"
#include "project/testbedApp/PlayableDemo/Globals.h"
#include "project/testbedApp/PlayableDemo/Resources.h"
#include "project/testbedApp/PlayableDemo/GameState.h"

int32_t
cQueueManager::add(cQueueEntry* entry)
{
    int32_t result = SizeL(_order);
    _order.push_back(entry);
    return result;
}

void
cQueueManager::remove(int32_t index)
{
    if(index + 1 != _order.size())
    {
        std::swap(_order[index], _order.back());
        _order[index]->indexChangedTo(index);
    }
    _order.pop_back();
}

void
cQueueEntry::updateQueueAgentPosition()
{
    if(_controlledObjectAgent->getPosition() != _queueCollisionAgent->getPosition())
    {
        _queueCollisionAgent->moveTo(_controlledObjectAgent->getPosition());
    }
}

cQueueEntry::cQueueEntry(cQueueManager& manager, int32_t shapeIndex, std::unique_ptr<iAgent> controlledObjectAgent) :
 _manager(manager),
 _controlledObjectAgent(std::move(controlledObjectAgent))
{
    _distanceToTarget = 0.f;
    iShape& shape = gResources->refShape(shapeIndex);
    if(!gGameState->refMesh().shapeCanCollide(shape))
    {
        gGameState->refMesh().generateUnobstructedSpaceFor(shape, true, 0);
    }
    _queueCollisionAgent = gGameState->refMesh().placeAgent(shape, _controlledObjectAgent->getPosition());
    _queueCollisionContext = gGameState->refMesh().newContext();
    _queueCollisionContext->addAgent(*_queueCollisionAgent);
    _queueIndex = _manager.add(this);
}

cQueueEntry::~cQueueEntry()
{
    _manager.remove(_queueIndex);
}

void
cQueueEntry::updateDistanceToTarget(float value)
{
    _distanceToTarget = value;
    if(_queueIndex > 0 && _distanceToTarget < _manager._order[_queueIndex - 1]->_distanceToTarget)
    {
    // advance
        std::swap(_manager._order[_queueIndex], _manager._order[_queueIndex - 1]);
        _manager._order[_queueIndex]->_queueIndex++;
        _queueIndex--;
    }
}

bool
cQueueEntry::testQueueCollision()
{
    if(_queueIndex == 0)
    {
        return false;
    }
    cQueueEntry* testAgainst = _manager._order[_queueIndex - 1];
    testAgainst->updateQueueAgentPosition();
    return _controlledObjectAgent->testCollisionAt(testAgainst->_queueCollisionContext.get(), _controlledObjectAgent->getPosition());
}

