
#ifndef QUEUEING_INCLUDED
#define QUEUEING_INCLUDED

#include "base/Container/Vector.h"
#include <memory>

class iAgent;
class iCollisionContext;

class cQueueEntry;
class cQueueManager
{
    PE::vector<cQueueEntry*> _order;

public:
    friend class cQueueEntry;

    int32_t add(cQueueEntry*);
    void remove(int32_t);

};

class cQueueEntry
{
    cQueueManager& _manager;
    int32_t _queueIndex;
    float _distanceToTarget;
    std::unique_ptr<iAgent> _controlledObjectAgent;
    std::unique_ptr<iCollisionContext> _queueCollisionContext;
    std::unique_ptr<iAgent> _queueCollisionAgent;

    void updateQueueAgentPosition();

public:

    cQueueEntry(cQueueManager& manager, int32_t shapeIndex, std::unique_ptr<iAgent> controlledObjectAgent);
    ~cQueueEntry();

    void indexChangedTo(int32_t value)
    {
        _queueIndex = value;
    }

    bool isLeader() const
    {
        return _queueIndex == 0;
    }
    float getDistanceToTarget() const
    {
        return _distanceToTarget;
    }
    int32_t queueIndex() const
    {
        return _queueIndex;
    }

    void updateDistanceToTarget(float value);
    bool testQueueCollision();
};

#endif
