#include "base/types/Header.h"
#include "project/testbedApp/PlayableDemo/Resources.h"
#include "project/testbedApp/PlayableDemo/Globals.h"
#include "sampleShared/SimpleDOM.h"
#include "sampleShared/LoadBinary.h"
#include "common/STL_Helper.h"
#include "externalAPI/i_pathengine.h"
#include <stdlib.h>

using std::string;
using PE::vector;

static void
LoadSplashImage(const char* fileName, int32_t expectedIndex)
{
    vector<char> buffer;
    LoadBinary(fileName, buffer);
    if(buffer.empty())
    {
        Error("Fatal", "Failed to load splash image, or file empty.");
    }
    int32_t index = gTestBed->createImage(VectorBuffer(buffer), SizeU(buffer));
    if(index == -1)
    {
        Error("Fatal", "Failed to create splash image.");
    }
    assertR(index == expectedIndex);
}

cResources::cResources(const cSimpleDOM& shapesScript)
{
    LoadSplashImage("../resource/splashImages/demo_begin.png", SPLASH_BEGIN);
    LoadSplashImage("../resource/splashImages/demo_died.png", SPLASH_DIED);
    LoadSplashImage("../resource/splashImages/demo_levelcomplete.png", SPLASH_LEVELCOMPLETE);
    LoadSplashImage("../resource/splashImages/demo_allcomplete.png", SPLASH_ALLCOMPLETE);
    LoadSplashImage("../resource/splashImages/demo_camera.png", SPLASH_CAMERA);

    for(int32_t i = 0; i < static_cast<int32_t>(shapesScript._children.size()); ++i)
    {
        const cSimpleDOM& element = shapesScript._children[i];
        if(element._name != "shape")
        {
            continue;
        }
        string verticesString = element.getAttribute("vertices");
        const char* ptr = verticesString.c_str();
        PE::vector<int32_t> coords;
        while(1)
        {
            char* nextPtr;
            coords.push_back(strtol(ptr, &nextPtr, 10));
            assertR(*nextPtr == ',');
            ptr = nextPtr + 1;
            coords.push_back(strtol(ptr, &nextPtr, 10));
            if(*nextPtr == 0)
            {
                break;
            }
            assertR(*nextPtr == ',');
            ptr = nextPtr + 1;
        }
        _shapes.push_back(gPathEngine->newShape(&coords.front(), SizeL(coords)));
    }
}
