#include "base/types/Header.h"
#include "project/testbedApp/PlayableDemo/RunAwayBehaviour.h"
#include "project/testbedApp/PlayableDemo/Globals.h"
#include "project/testbedApp/PlayableDemo/GameState.h"
#include "project/testbedApp/PlayableDemo/GameObject.h"
#include "project/testbedApp/PlayableDemo/PathFrequency.h"
#include "sampleShared/MoveAgent.h"
#include "sampleShared/SimpleDOM.h"
#include "externalAPI/i_pathengine.h"
#include <math.h>
#include <stdlib.h>

using std::string;

cRunAwayBehaviour::cRunAwayBehaviour(const cSimpleDOM& element, cGameObject& controlledObject)
{
    _distanceAway = element.attributeAsLong("distanceAway");
    _timeSincePathQuery = 0;
}

bool
cRunAwayBehaviour::update(cGameObject& controlledObject)
{
    cGameObject* target = controlledObject.getTarget();
    if(!target)
    {
        return true; // failed
    }
    
    int32_t frequency = 10;

    _timeSincePathQuery++;
    if(_timeSincePathQuery >= frequency)
    {
        _timeSincePathQuery = 0;
        _currentPath = controlledObject.findPathAway(target->getPosition(), _distanceAway);
    }

    if(_currentPath)
    {
        float speedMultiplier = 1.f;
        bool blocked = controlledObject.advanceAlongPath(_currentPath.get(), speedMultiplier);
        if(blocked)
        {
            _currentPath.reset();
        }
    }
    return false;
}
