#include "base/types/Header.h"
#include "project/testbedApp/PlayableDemo/SwitchResetterBehaviour.h"
#include "project/testbedApp/PlayableDemo/Globals.h"
#include "project/testbedApp/PlayableDemo/GameState.h"
#include "project/testbedApp/PlayableDemo/GameObject.h"
#include "project/testbedApp/PlayableDemo/PathFrequency.h"
#include "sampleShared/SimpleDOM.h"
#include "sampleShared/MoveAgent.h"
#include "externalAPI/i_pathengine.h"
#include <math.h>
#include <stdlib.h>
#include <memory>

using std::string;

cGameObject*
cSwitchResetterBehaviour::chooseRandomTarget() const
{
    size_t numberToggled = 0;
    for(auto target : _targets)
        if(target->_toggled)
            numberToggled++;
    if(numberToggled == 0)
        return 0;
    size_t selected = rand() % numberToggled;
    for(auto target : _targets)
    {
        if(target->_toggled)
        {
            if(selected == 0)
                return target;
            selected--;
        }
    }
    invalid();
    return 0;
}

cSwitchResetterBehaviour::cSwitchResetterBehaviour(const cSimpleDOM& element, cGameObject& controlledObject)
{
    _radius1 = element.attributeAsLong("radius1");
    int32_t radius2 = element.attributeAsLong("radius2");
    _radius3 = element.attributeAsLong("radius3");
    assertD(_radius1 > 0);
    assertD(radius2 > _radius1);
    assertD(_radius3 > radius2);

    _frightenedSound = element.attributeAsLongWithDefault("frightenedSound", -1);

    for(const auto& child : element._children)
    {
        if(child._name == "target")
        {
            std::string targetName = child.getAttribute("object");
            _targets.push_back(gGameState->findObject(targetName));
        }
    }

    std::unique_ptr<iShape> runAwayAreaShape;
    {
        int32_t vertices[8];
        vertices[0] = -_radius1;
        vertices[1] = -_radius1;
        vertices[2] = -_radius1;
        vertices[3] = _radius1;
        vertices[4] = _radius1;
        vertices[5] = _radius1;
        vertices[6] = _radius1;
        vertices[7] = -_radius1;
        runAwayAreaShape = gPathEngine->newShape(vertices, sizeof(vertices) / sizeof(*vertices));
    }
    _runAwayArea = gGameState->refMesh().placeAgent(*runAwayAreaShape, controlledObject.getPosition());

    _runAwayContext = gGameState->refMesh().newContext();
    _runAwayContext->addAgent(*_runAwayArea);

    std::unique_ptr<iShape> avoidAreaShape;
    {
        int32_t vertices[8];
        vertices[0] = -radius2;
        vertices[1] = -radius2;
        vertices[2] = -radius2;
        vertices[3] = radius2;
        vertices[4] = radius2;
        vertices[5] = radius2;
        vertices[6] = radius2;
        vertices[7] = -radius2;
        avoidAreaShape = gPathEngine->newShape(vertices, sizeof(vertices) / sizeof(*vertices));
    }
    _avoidArea = gGameState->refMesh().placeAgent(*avoidAreaShape, controlledObject.getPosition());

    _currentPath = 0;
    _timeSincePathQuery = 0;
    _state = IDLE;
}

bool
cSwitchResetterBehaviour::update(cGameObject& controlledObject)
{
    cGameObject* target = gGameState->findObject("player");
    assertR(target);

    float distance = controlledObject.distanceTo(*target);
    if(distance < _radius1 && _state != RUNNING_AWAY)
    {
        _runAwayArea->moveTo(target->getPosition());
        if(controlledObject.refAgent().testCollisionAt(_runAwayContext.get(), controlledObject.getPosition()))
        {
            _currentPath.reset();
            _state = RUNNING_AWAY;
            if(_frightenedSound != -1)
            {
                gTestBed->playSound(_frightenedSound);
            }
        }
    }
    else
    if(distance > _radius3 && _state != MOVING_TO_SWITCHES)
    {
        _currentPath.reset();
        _state = MOVING_TO_SWITCHES;
    }

    if(_state == IDLE)
    {
        return false;
    }

    _timeSincePathQuery++;
    if(_timeSincePathQuery >= 10 && (_state == RUNNING_AWAY || _currentPath == 0))
    {
        _timeSincePathQuery = 0;

        if(_state == RUNNING_AWAY)
        {
            _currentPath = controlledObject.findPathAway(target->getPosition(), _radius3 + 1);
        }
        else
        {
            assertD(_state == MOVING_TO_SWITCHES);
            _currentPath.reset();
            _currentTarget = chooseRandomTarget();
            if(_currentTarget)
            {
                _avoidArea->moveTo(target->getPosition());
                gGameState->refObstructionsContext().addAgent(*_avoidArea);
                if(!controlledObject.refAgent().testCollisionAt(&gGameState->refObstructionsContext(), _currentTarget->getPosition()))
                {
                    _currentPath = controlledObject.findShortestPathTo(_currentTarget->getPosition());
                }
                gGameState->refObstructionsContext().removeAgent(*_avoidArea);
            }
        }
    }

    if(_currentPath)
    {
        bool blocked = controlledObject.advanceAlongPath(_currentPath.get());
        if(blocked || _currentPath->size() == 1)
        {
            _currentPath.reset();
        }
    }
    else
    {
        controlledObject.faceTowards(target->getPosition());
    }
    return false;
}
