
#include "project/testbedApp/PlayableDemo/iBehaviour.h"
#include "base/Container/Vector.h"
#include "externalAPI/i_pathengine.h"
#include <memory>

class cSimpleDOM;
class cGameObject;
class iAgent;

class cSwitchResetterBehaviour : public iBehaviour
{    
    int32_t _radius1, _radius3;
    int32_t _frightenedSound;
    PE::vector<cGameObject*> _targets;
    std::unique_ptr<iAgent> _runAwayArea;
    std::unique_ptr<iCollisionContext> _runAwayContext;
    std::unique_ptr<iAgent> _avoidArea;

    enum eState
    {
        IDLE,
        RUNNING_AWAY,
        MOVING_TO_SWITCHES,
    } _state;
    cGameObject* _currentTarget;
    std::unique_ptr<iPath> _currentPath;
    int32_t _timeSincePathQuery;

    cGameObject* chooseRandomTarget() const;

public:

    cSwitchResetterBehaviour(const cSimpleDOM& element, cGameObject& controlledObject);

// interface for iController

    bool update(cGameObject& controlledObject);
};
