#include "base/types/Header.h"
#include "project/testbedApp/PlayableDemo/VisitGreenSceneryBehaviour.h"
#include "project/testbedApp/PlayableDemo/GameState.h"
#include "project/testbedApp/PlayableDemo/GameObject.h"
#include "project/testbedApp/PlayableDemo/Globals.h"
#include "sampleShared/SimpleDOM.h"
#include <stdlib.h>

cVisitGreenSceneryBehaviour::cVisitGreenSceneryBehaviour(const cSimpleDOM& element, cGameObject& controlledObject)
{
    _engageDistance = element.attributeAsFloat("engageDistance");
    PE::vector<cGameObject*> greenSceneryObjects;
    gGameState->findAllObjectsWithType("sceneryGreen", greenSceneryObjects);
    int32_t i;
    for(i = 0; i < static_cast<int32_t>(greenSceneryObjects.size()); ++i)
    {
        cGameObject* object = greenSceneryObjects[i];
        cPosition baseP = object->getPosition();
        cPosition unobstructedP = gGameState->refMesh().findClosestUnobstructedPosition(controlledObject.refShape(), &gGameState->refObstructionsContext(), baseP, 1000);
        if(unobstructedP.cell != -1)
        {
            _greenScenery.push_back(unobstructedP);
        }
    }
}

bool
cVisitGreenSceneryBehaviour::update(cGameObject& controlledObject)
{
    if(!_path)
    {
        auto i = static_cast<uint32_t>(rand() % _greenScenery.size());
        _path = controlledObject.findShortestPathTo(_greenScenery[i]);
        if(!_path)
        {
            return false;
        }
    }
    bool blocked = controlledObject.advanceAlongPath(_path.get());
    if(blocked || _path->size() == 1)
    {
        _path.reset();
    }
    return false;
}
