//**********************************************************************
//
// Copyright (c) 2007
// PathEngine
// Lyon, France
//
// All Rights Reserved
//
//**********************************************************************

#include "base/types/Header.h"
#include "project/testbedApp/SemiDynamicObstacles/DynamicAgentManager.h"
#include "sampleShared/MeshRenderGeometry.h"
#include "externalAPI/i_pathengine.h"
#include <stdlib.h>
cDynamicAgentManager::cDynamicAgentManager(iTestBed* testBed, iMesh* mesh, iShape* agentShape, const iCollisionContext& context, int32_t numberOfAgents) :
 _testBed(testBed),
 _mesh(mesh),
 _agentShape(agentShape),
 _agents(numberOfAgents),
 _paths(numberOfAgents),
 _regions(numberOfAgents, -1),
 _agentRenderGeometry(*testBed, *agentShape, 60)
{
    assertD(mesh->shapeCanCollide(*agentShape));
    int32_t i;
    for(i = 0; i != numberOfAgents; ++i)
    {
        cPosition p;
        do
        {
            p = mesh->generateRandomPosition();
        }
        while(mesh->testPointCollision(*agentShape, &context, p));
        _agents[i] = mesh->placeAgent(*agentShape, p);
        do
        {
            p = mesh->generateRandomPosition();
        }
        while(mesh->testPointCollision(*agentShape, &context, p));
        _paths[i] = _agents[i]->findShortestPathTo(&context, p);
    }
}

void
cDynamicAgentManager::moveAlongPaths(const iCollisionContext& context)
{
    for(int32_t i = 0; i != SizeL(_agents); ++i)
    {
        if(_paths[i])
        {
            bool collided = _agents[i]->advanceAlongPath(_paths[i].get(), 40.f, &context);
            if(collided || _paths[i]->size() == 1)
            {
                _paths[i].reset();
            }
        }
    }
}

void
cDynamicAgentManager::rePath(const iObstacleSet& preprocessedSet, const iCollisionContext& context, int32_t maxQueries)
{
    PE::vector<int32_t> toRepath;
    for(int32_t i = 0; i != SizeL(_agents); ++i)
    {
        if(_paths[i] == 0)
        {
            toRepath.push_back(i);
        }
    }
    int32_t numberToUpdate = maxQueries;
    if(numberToUpdate > SizeL(toRepath))
    {
        numberToUpdate = SizeL(toRepath);
    }
    for(int32_t i = 0; i != numberToUpdate; ++i)
    {
        int32_t r = rand() % SizeL(toRepath);
        int32_t selected = toRepath[r];
        int32_t currentRegion = preprocessedSet.getConnectedRegionForAgent(*_agents[selected]);
        cPosition p;
        for(int32_t j = 0; j != 40; ++j)
        {
            p = _mesh->generateRandomPosition();
            if(preprocessedSet.getConnectedRegionFor(*_agentShape, p) != currentRegion)
            {
                continue;
            }
            _paths[selected] = _agents[selected]->findShortestPathTo(&context, p);
            break;
        }
        // swap this agent out so we dont repath the same agent multiple times
        toRepath[r] = toRepath.back();
        toRepath.pop_back();
    }
}

void
cDynamicAgentManager::assignRegions(const iObstacleSet& preprocessedSet)
{
    for(int32_t i = 0; i != SizeL(_agents); ++i)
    {
        _regions[i] = preprocessedSet.getConnectedRegionForAgent(*_agents[i]);
    }
}

void
cDynamicAgentManager::renderAgents() const
{
    for(int32_t i = 0; i != SizeL(_agents); ++i)
    {
        _agentRenderGeometry.renderAt(*_testBed, *_mesh, _agents[i]->getPosition());
    }
}
void
cDynamicAgentManager::renderAgents_ColouredByRegion() const
{
    const char* colours[] = {"green", "orange", "yellow", "lightpurple", "pink", "lightblue"};
    int32_t numberOfColours = sizeof(colours) / sizeof(*colours);
    for(int32_t i = 0; i != SizeL(_agents); ++i)
    {
        if(_regions[i] == -1)
        {
            _testBed->setColour("red");
        }
        else
        {
            _testBed->setColour(colours[_regions[i] % numberOfColours]);
        }
        _agentRenderGeometry.renderAt(*_testBed, *_mesh, _agents[i]->getPosition());
    }
}
void
cDynamicAgentManager::renderPaths() const
{
    for(int32_t i = 0; i != SizeL(_paths); ++i)
    {
        if(_paths[i])
            cMeshRenderGeometry::DrawPath(*_testBed, *_paths[i]);
    }
}
