//**********************************************************************
//
// Copyright (c) 2007
// PathEngine
// Lyon, France
//
// All Rights Reserved
//
//**********************************************************************

#pragma once

#include "sampleShared/AgentRenderGeometry.h"
#include <vector>
#include <memory>

class iTestBed;
class iAgent;
class iPath;
class iMesh;
class iShape;
class iObstacleSet;
class iCollisionContext;

class cDynamicAgentManager
{
    iTestBed* _testBed;
    iMesh* _mesh;
    iShape* _agentShape;
    cAgentRenderGeometry _agentRenderGeometry;
    PE::vector<std::unique_ptr<iAgent>> _agents;
    PE::vector<std::unique_ptr<iPath>> _paths;
    PE::vector<int32_t> _regions;

public:

    cDynamicAgentManager(iTestBed* testBed, iMesh* mesh, iShape* agentShape, const iCollisionContext& context, int32_t numberOfAgents);

    int32_t size()
    {
        return SizeL(_agents);
    }

    void moveAlongPaths(const iCollisionContext& context);
    void rePath(const iObstacleSet& preprocessedSet, const iCollisionContext& context, int32_t maxQueries);

    void assignRegions(const iObstacleSet& preprocessedSet);

    void renderAgents() const;
    void renderAgents_ColouredByRegion() const;
    void renderPaths() const;
};
