
//**********************************************************************
//
// Copyright (c) 2012
// PathEngine
// Lyon, France
//
// All Rights Reserved
//
//**********************************************************************

#include "base/Container/Vector.h"
#include <memory>

class iMesh;
class iShape;
class iCollisionContext;
class iAgent;
class iPath;
class cPosition;
class cMovementOrder;

class cAgentAI
{
    std::shared_ptr<iMesh> _mesh;
    std::shared_ptr<iShape> _agentShape;
    std::shared_ptr<iShape> _avoidShape;
    std::shared_ptr<iCollisionContext> _atRestContext;
    std::shared_ptr<iCollisionContext> _avoidContext;
    PE::vector<std::shared_ptr<iAgent>> _agents;
    PE::vector<std::shared_ptr<iAgent>> _avoidAgents;
    PE::vector<std::shared_ptr<iPath>> _agentPaths;
    PE::vector<cMovementOrder*> _movementOrders;
    PE::vector<int32_t> _agentMovementOrders;

    void pathsToSingleTarget(const PE::vector<int32_t>& selectedAgents, const cPosition& targetPosition);

public:

    cAgentAI(std::shared_ptr<iMesh> mesh, std::shared_ptr<iShape> agentShape, std::shared_ptr<iShape> avoidShape);
    ~cAgentAI();

    int32_t
    numberOfAgents() const
    {
        return SizeL(_agents);
    }
    iAgent&
    refAgent(int32_t i)
    {
        return *_agents[i];
    }
    // avoid agents are used for rendering, to highlight selected agents
    iAgent&
    refHighlightAgent(int32_t i)
    {
        return *_avoidAgents[i];
    }
    int32_t
    agentGroupIndex(int32_t i) const
    {
        return _agentMovementOrders[i];
    }

    void stopOrder(const PE::vector<int32_t>& selectedAgents);
    void moveOrder(const PE::vector<int32_t>& selectedAgents, const cPosition& targetPosition);
    void moveOrder(const PE::vector<int32_t>& selectedAgents, const PE::vector<cPosition>& waypoints, bool repeat);
    void update();
};
