
#pragma once

#include "sampleShared/MeshRenderGeometry.h"
#include "sampleShared/AgentRenderGeometry.h"
#include "externalAPI/i_pathengine.h"
#include "base/Container/Vector.h"
#include "platform_common/Mutex.h"
#include <memory>

class iTestBed;

class cMeshAndAgents
{
    std::unique_ptr<iShape> _agentShape;
    std::unique_ptr<iMesh> _mesh;
    cMeshRenderGeometry _meshRenderGeometry;
    cAgentRenderGeometry _agentRenderGeometry;
    PE::vector<std::unique_ptr<iAgent>> _agents;
    PE::vector<std::unique_ptr<iPath>> _paths;
    PE::vector<cPosition> _positionsBeforeUpdate;
    int32_t _queryCount;
    int32_t _agentsToAdd;
    bool _terminate;
    mutable cMutex _positionsMutex;
    mutable cMutex _queryCountMutex;
    mutable cMutex _agentAddMutex;
    mutable cMutex _terminateMutex;

    void generatePreprocessIfNotPresent();
    void doAddAgent();
    void updateAgent(int32_t i);

public:

    cMeshAndAgents(
            iPathEngine& pathEngine,
            iTestBed& testBed,
            iShape& agentShape,
            const PE::vector<char>& meshBuffer
            );

// per thread execution logic, with update loop

    void run();

// called from main thread to affect execution

    void addAgent();

// called from main thread for rendering or stats

    void render(iTestBed& testBed, int32_t meshSlot, bool initCamera) const;
    int32_t getQueryCount() const;

// called from main thread to request termination

    void terminate();
};
