#pragma once

#include "base/Container/Vector.h"
#include <memory>

class iTestBed;
class iMesh;
class iShape;
class iAgent;
class iRenderGeometry;
class cPosition;

class cAgentRenderGeometry
{
    std::unique_ptr<iRenderGeometry> _geometry;
    static void AddCylinder(const PE::vector<float>& shapeCoords, float startZ, float endZ, iRenderGeometry& addTo);
public:
    static void AddCylinder(const iShape& shape, float height, iRenderGeometry& addTo);
    static void AddCylinder(const iAgent& agent, float height, iRenderGeometry& addTo);
    static void AddAgentExpansion(const iAgent& agent, const iShape& expandShape, iRenderGeometry& addTo);
    static void AddDirectionArrowRenderGeometry(const iAgent& agent, float height, float size, float direction, float precisionX, float precisionY, iRenderGeometry& addTo);
    static void DrawAgentHeading(iTestBed& testBed, const iAgent& agent, float height, float size, float direction, float precisionX = 0.f, float precisionY = 0.f);

    cAgentRenderGeometry(iTestBed& testBed, const iShape& shape, float height);

    void renderAt(iTestBed& testBed, iMesh& mesh, cPosition position) const;
    void renderAt(iTestBed& testBed, iMesh& mesh, cPosition position, float precisionX, float precisionY) const;
};
