#pragma once

#include "sampleShared/MeshLOSPreprocess.h"
#include "externalAPI/i_pathengine.h"

inline int32_t
CameraControl_DesiredState(iTestBed& testBed)
{
    // Maya style camera controls
    bool control = testBed.getKeyState("_LCONTROL");
    bool leftMouse = testBed.getKeyState("_LMOUSE");
    bool middleMouse = testBed.getKeyState("_MMOUSE");
    int32_t desiredState = PE_CameraControl_None;
    if(control && leftMouse && middleMouse)
    {
        desiredState = PE_CameraControl_Zoom;
    }
    else if(control && leftMouse)
    {
        desiredState = PE_CameraControl_Rotate;
    }
    else if(control && middleMouse)
    {
        desiredState = PE_CameraControl_Pan;
    }
    // fallback controls, in case there is no middle mouse button
    if(testBed.getKeyState("1"))
    {
        desiredState = PE_CameraControl_Rotate;
    }
    if(testBed.getKeyState("2"))
    {
        desiredState = PE_CameraControl_Pan;
    }
    if(testBed.getKeyState("3"))
    {
        desiredState = PE_CameraControl_Zoom;
    }
    return desiredState;
}
inline void
CameraControl(iTestBed& testBed, cMeshLOSPreprocess& losPreprocess)
{
    int32_t desiredState = CameraControl_DesiredState(testBed);
    testBed.setCameraControlState(desiredState);
    if(desiredState != PE_CameraControl_None)
    {
        // enable camera target distance adjustment, to avoid user getting lost rotating around positions at arbitrary distances
        cVector3F positionAtMouse;
        if(losPreprocess.positionAtMouse(testBed, positionAtMouse))
        {
            testBed.setCameraControlTarget(positionAtMouse.x(), positionAtMouse.y(), positionAtMouse.z());
        }
    }
}
inline void
CameraControl(iTestBed& testBed)
{
    int32_t desiredState = CameraControl_DesiredState(testBed);
    testBed.setCameraControlState(desiredState);
}
