#pragma once

#include "sampleShared/FaceVertexMesh.h"
#include "base/Container/Vector.h"
#include <memory>

class cFaceVertexBuilder : public iFaceVertexBuilder
{
public:

	PE::vector<std::unique_ptr<cFaceVertexMesh> > _meshes;

// iFaceVertexBuilder interface

    void startMesh()
    {
        _meshes.push_back(std::unique_ptr<cFaceVertexMesh>(new cFaceVertexMesh()));
    }
    int32_t addVertex(int32_t x, int32_t y, float z)
    {
        return _meshes.back()->addVertex(x, y, z);
    }
    int32_t addFace(int32_t vertex0, int32_t vertex1, int32_t vertex2)
    {
        return _meshes.back()->addFace(vertex0, vertex1, vertex2);
    }
    void setFaceAttribute(int32_t faceIndex, int32_t attributeType, int32_t attributeValue)
    {
        _meshes.back()->setFaceAttribute(faceIndex, attributeType, attributeValue);
    }

// (end of iFaceVertexBuilder interface)

    void addInterfacePointers(PE::vector<const iFaceVertexMesh*>& addTo) const
    {
        for(const auto& meshPtr:_meshes)
        {
            addTo.push_back(meshPtr.get());
        }
    }
};
