#include "base/types/Header.h"
#include "sampleShared/FaceVertexMesh.h"
#include "sampleShared/CoordinateMapping.h"
#include <stddef.h>

int32_t
cFaceVertexMesh::addVertex(int32_t x, int32_t y, float z)
{
    int32_t addedIndex = SizeL(_vertexZ);
    _vertexXY.push_back(x);
    _vertexXY.push_back(y);
    _vertexZ.push_back(z);
    return addedIndex;
}
int32_t
cFaceVertexMesh::addFace(int32_t vertex0, int32_t vertex1, int32_t vertex2)
{
    int32_t addedIndex = SizeL(_vertexIndices) / 3;
    _vertexIndices.push_back(vertex0);
    _vertexIndices.push_back(vertex1);
    _vertexIndices.push_back(vertex2);
    return addedIndex;
}
void
cFaceVertexMesh::setFaceAttribute(int32_t faceIndex, int32_t attributeType, int32_t attributeValue)
{
    if(_faceAttributes.empty())
    {
        _faceAttributes.resize(PE_FaceAttribute_Top + 1);
    }
    size_t i = static_cast<size_t>(faceIndex);
    if(i >= _faceAttributes[attributeType].size())
    {
        _faceAttributes[attributeType].resize(i + 1, 0);
    }
    _faceAttributes[attributeType][i] = attributeValue;
}

void
cFaceVertexMesh::applyCoordinateMapping(const cCoordinateMapping& mapping)
{
    int32_t triCoords[3];
    for(int32_t i = 0; i != vertices(); ++i)
    {
        triCoords[0] = _vertexXY[i * 2];
        triCoords[1] = _vertexXY[i * 2 + 1];
        triCoords[2] = static_cast<int32_t>(_vertexZ[i]);
        mapping.applyTo(triCoords);
        _vertexXY[i * 2] = triCoords[0];
        _vertexXY[i * 2 + 1] = triCoords[1];
        _vertexZ[i] = static_cast<float>(triCoords[2]);
    }
}

// iFaceVertexMesh interface

int32_t
cFaceVertexMesh::faces() const
{
    return static_cast<int32_t>(_vertexIndices.size() / 3);
}
int32_t
cFaceVertexMesh::vertices() const
{
    return static_cast<int32_t>(_vertexZ.size());
}
int32_t
cFaceVertexMesh::vertexIndex(int32_t face, int32_t vertexInFace) const
{
    return _vertexIndices[face * 3 + vertexInFace];
}
int32_t
cFaceVertexMesh::vertexX(int32_t vertex) const
{
    return _vertexXY[vertex * 2 + 0];
}
int32_t
cFaceVertexMesh::vertexY(int32_t vertex) const
{
    return _vertexXY[vertex * 2 + 1];
}
float
cFaceVertexMesh::vertexZ(int32_t vertex) const
{
    return _vertexZ[vertex];
}
int32_t
cFaceVertexMesh::faceAttribute(int32_t faceIndex, int32_t attributeType) const
{
    if(_faceAttributes.empty())
    {
        return 0;
    }
    size_t i = static_cast<size_t>(faceIndex);
    if(i >= _faceAttributes[attributeType].size())
    {
        return 0;
    }
    return _faceAttributes[attributeType][i];
}
