#pragma once

#include "base/Container/Vector.h"
#include "externalAPI/i_pathengine.h"

class cCoordinateMapping;

class cFaceVertexMesh : public iFaceVertexMesh
{
    PE::vector<int32_t> _vertexXY;
    PE::vector<float> _vertexZ;
    PE::vector<int32_t> _vertexIndices;

    // one vector per attribute,
    // and then sub vectors with entries per face
    // size for outer vector to be set once (when first attribute is set) and then left as is!
    // and each sub vector is then only resized when necessary
    // given that face index outside of one of these vectors indicates attribute value of zero
    PE::vector<std::vector<int32_t> > _faceAttributes;

public:

    // construction methods, to correspond with methods in iFaceVertexBuilder

    int32_t addVertex(int32_t x, int32_t y, float z);
    int32_t addFace(int32_t vertex0, int32_t vertex1, int32_t vertex2);
    void setFaceAttribute(int32_t faceIndex, int32_t attributeType, int32_t attributeValue);

    // legacy method versions, just for compatibility with old code
    int32_t addVert(const int32_t* coords)
    {
        return addVertex(coords[0], coords[1], static_cast<float>(coords[2]));
    }
    void addTri(const int32_t* vertIndices)
    {
        addFace(vertIndices[0], vertIndices[1], vertIndices[2]);
    }

    // ** note that this forces the vertex z coords to round trip through a cast to int32_t **
    void applyCoordinateMapping(const cCoordinateMapping& mapping);

// iFaceVertexMesh interface

    int32_t faces() const;
    int32_t vertices() const;
    int32_t vertexIndex(int32_t face, int32_t vertexInFace) const;
    int32_t vertexX(int32_t vertex) const;
    int32_t vertexY(int32_t vertex) const;
    float vertexZ(int32_t vertex) const;
    int32_t faceAttribute(int32_t faceIndex, int32_t attributeType) const;
};
