
#include "base/types/Header.h"
#include "sampleShared/LoadContentChunkPlacement.h"
#include "sampleShared/SimpleDOM.h"
#include "sampleShared/LoadBinary.h"
#include "common/STL_Helper.h"
#include "externalAPI/i_pathengine.h"
#include <map>

using std::unique_ptr;

static unique_ptr<iContentChunk>
LoadChunk(iPathEngine* pathEngine, iTestBed* testBed, const std::string& name)
{
    std::string fileName = "../resource/content/";
    fileName.append(name);
    fileName.append(".tok");
    PE::vector<char> buffer;
    LoadBinary(fileName.c_str(), buffer);
    return pathEngine->loadContentChunk(VectorBuffer(buffer), SizeU(buffer));
}

void
LoadContentChunkPlacement(
        iPathEngine* pathEngine, iTestBed* testBed, 
        const cSimpleDOM& placementScript,
        PE::vector<std::unique_ptr<iContentChunkInstance>>& placedInstances,
        bool setUniqueSectionIDs
        )
{
    assertR(placementScript._name == "contentChunkPlacement");
    std::map<std::string, unique_ptr<iContentChunk>> loadedChunksMap;
    for(int32_t i = 0; i != placementScript._children.size(); ++i)
    {
        int32_t nextIndex = static_cast<int32_t>(placedInstances.size()) + 1; // zero is reserved for terrain stand-in

      // process the document element
        const cSimpleDOM& instanceDOM = placementScript._children[i];
        if(instanceDOM._name == "chunk")
        {
            const std::string chunkName = instanceDOM.getAttribute("name");
            if(loadedChunksMap.find(chunkName) == loadedChunksMap.end())
            {
                loadedChunksMap[chunkName] = LoadChunk(pathEngine, testBed, chunkName);
            }
            iContentChunk& chunk = *loadedChunksMap[chunkName];

            int32_t sectionID = -1; // passing -1 tells iContentChunk::instantiate() not to override sectionID
            if(setUniqueSectionIDs)
            {
                sectionID = nextIndex;
            }

            placedInstances.push_back(chunk.instantiate(
                    instanceDOM.attributeAsLong("rotation"),                
                    instanceDOM.attributeAsLong("scale"),
                    instanceDOM.attributeAsLong("x"),
                    instanceDOM.attributeAsLong("y"),
                    instanceDOM.attributeAsFloat("z"),
                    sectionID
                    ));
            continue;
        }

        if(instanceDOM._name == "edgeToEdgeConnection")
        {
            int32_t from = instanceDOM.attributeAsLong("fromInstance");
            int32_t fromEdgeIndex = instanceDOM.attributeAsLong("fromEdgeIndex");
            int32_t to = instanceDOM.attributeAsLong("toInstance");
            int32_t toEdgeIndex = instanceDOM.attributeAsLong("toEdgeIndex");
            if(from <= 0 || from >= nextIndex)
            {
                Error("NonFatal", "Bad fromInstance value in edgeToEdgeConnection element.");
                continue;
            }
            if(to <= 0 || to >= nextIndex)
            {
                Error("NonFatal", "Bad toInstance value in edgeToEdgeConnection element.");
                continue;
            }
            iContentChunkInstance& fromInstance = *placedInstances[from - 1];
            iContentChunkInstance& toInstance = *placedInstances[to - 1];
            if(fromEdgeIndex < 0 || fromEdgeIndex >= fromInstance.numberOfConnectingEdges())
            {
                Error("NonFatal", "Bad fromEdgeIndex value in edgeToEdgeConnection element.");
                continue;
            }
            if(toEdgeIndex < 0 || toEdgeIndex >= toInstance.numberOfConnectingEdges())
            {
                Error("NonFatal", "Bad toEdgeIndex value in edgeToEdgeConnection element.");
                continue;
            }
            if(!fromInstance.edgesCanConnect(fromEdgeIndex, toInstance, toEdgeIndex))
            {
                Error("NonFatal", "An edge pair specified as connecting in the placement file cannot be connected.");
                continue;
            }

            fromInstance.makeEdgeConnection(fromEdgeIndex, toInstance, toEdgeIndex);
            continue;
        }
    }
}
