//**********************************************************************
//
// Copyright (c) 2002-2012
// PathEngine
// Lyon, France
//
// All Rights Reserved
//
//**********************************************************************

#pragma once

#include "sampleShared/LineCollidesWithTriangle.h"
#include "base/Container/Vector.h"
#include <memory>

class iTestBed;
class iMesh;
class cPosition;
class cVector3F;

class cMeshLOSPreprocess
{
    std::unique_ptr<const iMesh> _mesh;
    PE::vector<nLineCollidesWithTriangle::cTriPreprocess> _tris;

public:
    cMeshLOSPreprocess(const iMesh& mesh);

    bool lineCollides(const nLineCollidesWithTriangle::cLinePreprocess& line, int32_t& faceIndex) const;
    bool rayCollides(const nLineCollidesWithTriangle::cLinePreprocess& line, int32_t& faceIndex, float& fractionAlong) const;
    void getFacesObstructingLine(const nLineCollidesWithTriangle::cLinePreprocess& line, PE::vector<int32_t>& appendTo) const;

    bool pickPosition(
        const cVector3F& cameraPosition, const cVector3F& targetScreenPosition,
        cPosition& result,
        cVector3F& approximatePoint
        ) const;
    bool positionAtMouse(
        iTestBed& testBed,
        cPosition& result,
        cVector3F& approximatePoint
        ) const;
    cPosition positionAtMouse(iTestBed& testBed) const;
    bool positionAtMouse(iTestBed& testBed, cVector3F& result) const;
};
