#pragma once

#include <memory>
#include <vector>

class iTestBed;
class iMesh;
class iShape;
class iPath;
class iRenderGeometry;
class cPosition;
class cHorizontalRange;

class cMeshRenderGeometry
{
    std::unique_ptr<iRenderGeometry> _tris;
    std::unique_ptr<iRenderGeometry> _edges;
    std::unique_ptr<iRenderGeometry> _baseObstacles;
    std::unique_ptr<iRenderGeometry> _shapeExpansion;
    void constructorCommon(iTestBed& testBed, const iMesh& mesh);
public:

    static void AddMeshTris(const iMesh& mesh, iRenderGeometry& addTo);
    static void AddMeshEdges(const iMesh& mesh, bool includeInternalEdges, iRenderGeometry& addTo);
    static void AddUnobstructedSpaceBoundaries(const iMesh& mesh, const iShape& expansionShape, iRenderGeometry& addTo);
    static void AddSplitBoundaries(const iMesh& mesh, const iShape& expansionShape, iRenderGeometry& addTo);
    static void AddUnsplitBoundaries(const iMesh& mesh, const iShape& expansionShape, iRenderGeometry& addTo);
    static void Add3DCross(const iMesh& mesh, cPosition position, float size, iRenderGeometry& addTo);
    static void AddLineOnGround(const iMesh& mesh, cPosition start, int32_t endX, int32_t endY, iRenderGeometry& addTo);
    static void AddPath(const iPath& path, iRenderGeometry& addTo);
    static void AddRangeBounds(const iMesh& mesh, cHorizontalRange range, iRenderGeometry& addTo);
    static void Draw3DCross(iTestBed& testBed, const iMesh& mesh, cPosition position, float size);
    static void DrawLineOnGround(iTestBed& testBed, const iMesh& mesh, cPosition start, int32_t endX, int32_t endY);
    static void DrawPath(iTestBed& testBed, const iPath& path);

    cMeshRenderGeometry(iTestBed& testBed, const iMesh& mesh);
    cMeshRenderGeometry(iTestBed& testBed, const iMesh& mesh, const iShape& expansionShape);
    void render(iTestBed& testBed) const;
};
