
#pragma once

#include "externalAPI/i_pathengine.h"

class cPartitionedTerrain : public iFaceVertexMesh
{
    int32_t _originX, _originY;
    int32_t _squareSize, _squaresAcross;

public:

    cPartitionedTerrain(
            int32_t originX, int32_t originY,
            int32_t squareSize, int32_t squares
            ) :
     _originX(originX),
     _originY(originY),
     _squareSize(squareSize),
     _squaresAcross(squares)
    {
    }

// iFaceVertexMesh interface

    int32_t faces() const
    {
        return _squaresAcross * _squaresAcross * 2;
    }
    int32_t vertices() const
    {
        return (_squaresAcross + 1) * (_squaresAcross + 1);
    }
    int32_t vertexIndex(int32_t face, int32_t vertexInFace) const
    {
        int32_t baseVertex = face / 2 + face / 2 / _squaresAcross;
        if(face & 1)
        {
            switch(vertexInFace)
            {
            default:
//                invalid
            case 0:
                return baseVertex;
            case 1:
                return baseVertex + 1;
            case 2:
                return baseVertex + (_squaresAcross + 1) + 1;
            }
        }
        switch(vertexInFace)
        {
        default:
//            invalid
        case 0:
            return baseVertex;
        case 1:
            return baseVertex + (_squaresAcross + 1) + 1;
        case 2:
            return baseVertex + (_squaresAcross + 1);
        }
    }
    int32_t vertexX(int32_t vertex) const
    {
        return _originX + vertex / (_squaresAcross + 1) * _squareSize;
    }
    int32_t vertexY(int32_t vertex) const
    {
        return _originY + (vertex % (_squaresAcross + 1)) * _squareSize;
    }
    float vertexZ(int32_t vertex) const
    {
        return 0.0f;
    }
    int32_t faceAttribute(int32_t face, int32_t attributeIndex) const
    {
        if(attributeIndex == PE_FaceAttribute_SectionID)
        {
            return 0; // mark all faces as sectionID == 0 (first terrain layer)
        }
        return -1;
    }
};

