#include "sampleShared/PathStressSetup.h"
#include "sampleShared/RunPathStressWithConfig.h"

cPathStressSetup::cPathStressSetup(iPathEngine& pathEngine)
{
    {
        int32_t array[] =
        {
            -20, 20,
            20, 20,
            20, -20,
            -20, -20,
        };
        _shape_Square20 = pathEngine.newShape(array, sizeof(array) / sizeof(*array));
    }
    {
        int32_t array[] =
        {
            8,20,
            20,8,
            20,-8,
            8,-20,
            -8,-20,
            -20,-8,
            -20,8,
            -8,20,
        };
        _shape_Octagon8_20 = pathEngine.newShape(array, sizeof(array) / sizeof(*array));
    }
    {
        int32_t array[] =
        {
            0,16,
            14,-8,
            -14,-8,
        };
        _shape_Swarmer = pathEngine.newShape(array, sizeof(array) / sizeof(*array));
    }
    {
        int32_t array[] =
        {
            -60,60,
            60,60,
            60,-60,
            -60,-60,
        };
        _shape_Square60 = pathEngine.newShape(array, sizeof(array) / sizeof(*array));
    }

    _baseObstacles.push_back(_shape_Square60.get());
    _baseObstacles.push_back(_shape_Square60.get());
    _baseObstacles.push_back(_shape_Swarmer.get());
    _baseObstacles.push_back(_shape_Swarmer.get());
    _baseObstacles.push_back(_shape_Square20.get());
    _baseObstacles.push_back(_shape_Square20.get());
    _baseObstacles.push_back(_shape_Octagon8_20.get());
    _baseObstacles.push_back(_shape_Octagon8_20.get());

    _dynamicObstacles.push_back(_shape_Square60.get());
    _dynamicObstacles.push_back(_shape_Swarmer.get());
    _dynamicObstacles.push_back(_shape_Octagon8_20.get());

    uint32_t noAttributesIndex = static_cast<uint32_t>(_attributeSets.size());
    _attributeSets.emplace_back();
    _attributeSets.back().push_back(nullptr);

    uint32_t splitSmallConvexIndex = static_cast<uint32_t>(_attributeSets.size());
    _attributeSets.emplace_back();
    _attributeSets.back().push_back("splitWithCircumferenceBelow");
    _attributeSets.back().push_back("2000");
    _attributeSets.back().push_back(nullptr);

    uint32_t optimiseUnobstructedSpaceIndex = static_cast<uint32_t>(_attributeSets.size());
    _attributeSets.emplace_back();
    _attributeSets.back().push_back("optimiseWithRange");
    _attributeSets.back().push_back("15");
    _attributeSets.back().push_back(nullptr);

    _expandShapes.push_back(_shape_Swarmer.get());
    _expandOptions.push_back(noAttributesIndex);

    _expandShapes.push_back(_shape_Swarmer.get());
    _expandOptions.push_back(splitSmallConvexIndex);

    _expandShapes.push_back(_shape_Octagon8_20.get());
    _expandOptions.push_back(noAttributesIndex);

    _expandShapes.push_back(_shape_Octagon8_20.get());
    _expandOptions.push_back(splitSmallConvexIndex);

    _expandShapes.push_back(_shape_Square20.get());
    _expandOptions.push_back(noAttributesIndex);

    _expandShapes.push_back(_shape_Square20.get());
    _expandOptions.push_back(splitSmallConvexIndex);

    _expandShapes.push_back(_shape_Square20.get());
    _expandOptions.push_back(optimiseUnobstructedSpaceIndex);
}

void 
cPathStressSetup::runStressTest(iPathEngine& pathEngine, int32_t randomSeed, int32_t expansion, iPathStressVisualisationCallBack* visualisationCallBack) const
{
    assertR(expansion >= 0);
    assertR(expansion < numberOfExpansions());

    pathEngine.setRandomSeed(static_cast<uint32_t>(randomSeed));

    uint32_t attributeSet = _expandOptions[expansion];
    RunPathStressWithConfig(&pathEngine, "mesh1", *_expandShapes[expansion], _baseObstacles, _dynamicObstacles,
        10, // baseObstacleIterations
        5, // dynamicObstacleIterations
        100, // pathIterations
        _attributeSets[attributeSet].data(),
        0,
        visualisationCallBack
    );
}
