#pragma once

//#include "base/Container/Vector.h"
#include "base/types/SizeCasts.h"
#include "base/Container/Vector.h"
#include "externalAPI/i_pathengine.h"
#include <memory>
#include <stdint.h>

class iPathStressVisualisationCallBack;

class cPathStressSetup
{
    std::unique_ptr<iShape> _shape_Square20;
    std::unique_ptr<iShape> _shape_Octagon8_20;
    std::unique_ptr<iShape> _shape_Swarmer;
    std::unique_ptr<iShape> _shape_Square60;
    PE::vector<iShape*> _baseObstacles;
    PE::vector<iShape*> _dynamicObstacles;

    PE::vector<std::vector<const char*>> _attributeSets;

    PE::vector<iShape*> _expandShapes;
    PE::vector<uint32_t> _expandOptions;

public:

    cPathStressSetup(iPathEngine& pathEngine);

    int32_t version() const { return 0; }
    int32_t numberOfExpansions() const { return SizeL(_expandShapes); }

    void runStressTest(iPathEngine& pathEngine, int32_t randomSeed, int32_t expansion, iPathStressVisualisationCallBack* visualisationCallBack) const;
};