#include "base/Container/Vector.h"
#include "externalAPI/i_pathengine.h"
#include <memory>

class cRenderGeometryRenderCallBack : public iRender3DLinesCallBack
{
    PE::vector<float> _pointData;
    std::unique_ptr<iRenderGeometry> _geometry;
    void addAndClear()
    {
        if(_pointData.empty())
            return;
        _geometry->addLineSequence(&_pointData.front(), static_cast<uint32_t>(_pointData.size()));
        _pointData.clear();
    }
public:
    cRenderGeometryRenderCallBack(iRenderGeometry& geometry) :
        _geometry(geometry.addExternalRef())
    {
    }
    ~cRenderGeometryRenderCallBack()
    {
        addAndClear();
    }
    void startVertex(int32_t terrainLayer, float x, float y, float z) override
    {
        addAndClear();
        _pointData.push_back(x);
        _pointData.push_back(y);
        _pointData.push_back(z);
    }
    void vertex(float x, float y, float z) override
    {
        _pointData.push_back(x);
        _pointData.push_back(y);
        _pointData.push_back(z);
    }
};
