
#include "base/Container/Vector.h"
#include <string>

class iPathEngine;
class iTestBed;
class iShape;
class iPath;
class iMesh;
class iCollisionContext;

class iPathStressVisualisationCallBack
{
public:
    virtual ~iPathStressVisualisationCallBack() {}
    virtual void newMesh(const iMesh& mesh, bool firstIteration) = 0;
    virtual void newDynamicObstacleSet(const iCollisionContext& context) = 0;
    virtual void renderMeshAndContext() const = 0;
    virtual void renderPath(const iPath& path) const = 0;
    virtual void update() const = 0;
};

void RunPathStressWithConfig(iPathEngine* pathengine, 
    const std::string& meshName,
    iShape& agentShape,
    const PE::vector<iShape*>& baseObstacleShapes,
    const PE::vector<iShape*>& dynamicObstacleShapes,
    int32_t baseObstacleIterations,
    int32_t dynamicObstacleIterations,
    int32_t pathIterations,
    const char *const* unobstructedSpaceAttributes,
    const char *const* loadOptions,
    iPathStressVisualisationCallBack* visualisationCallBack
);
