#include "base/types/Header.h"
#include "sampleShared/SelectAndMove.h"
#include "base/Geometry/HorizontalRange_Helper.h"
#include "externalAPI/i_pathengine.h"
#include <string.h>

static void
DrawRectangle2D(iTestBed& testbed, int32_t corner1X, int32_t corner1Y, int32_t corner2X, int32_t corner2Y)
{
    testbed.drawLine2D(corner1X, corner1Y, corner2X, corner1Y);
    testbed.drawLine2D(corner1X, corner1Y, corner1X, corner2Y);
    testbed.drawLine2D(corner2X, corner2Y, corner2X, corner1Y);
    testbed.drawLine2D(corner2X, corner2Y, corner1X, corner2Y);
}

void
cSelectAndMove::update(iTestBed& testbed, bool& completed)
{
    completed = false;
    if(!_active)
    {
        return;
    }
  // draw selection box
    if(testbed.getLeftMouseState())
    {
      // still selecting a region - draw current select region
        testbed.setColour("green");
        int32_t x, y;
        testbed.getMouseScreenPosition(x, y);
        DrawRectangle2D(testbed, _startX, _startY, x, y);
        return;
    }
    completed = true;
    _active = false;
}

void
cSelectAndMove::updateSelectionSet(
        iTestBed& testbed, 
        PE::vector<float>& agentScreenPositions,
        PE::vector<bool>& agentSelected,
        PE::vector<int32_t>& selectedAgents
        ) const
{
    assertD(!_active); // should only be called just after update method returns completed

    int32_t agents = SizeL(agentSelected);
    assertD(SizeL(agentScreenPositions) == agents * 2);

    cHorizontalRange range;
    InitialiseRange(range, _startX, _startY);
    int32_t x, y;
    testbed.getMouseScreenPosition(x, y);
    ExtendRange(range, x, y);
    while(range.maxX - range.minX < 5)
    {
        ++range.maxX;
        --range.minX;
    }
    while(range.maxY - range.minY < 5)
    {
        ++range.maxY;
        --range.minY;
    }

    selectedAgents.clear();
    for(int32_t i = 0; i != agents; ++i)
    {
        int32_t screenX = static_cast<int32_t>(agentScreenPositions[i * 2]);
        int32_t screenY = static_cast<int32_t>(agentScreenPositions[i * 2 + 1]);
        bool inRange = RangeContainsPoint_Inclusive(range, screenX, screenY);
        if(testbed.getKeyState("_SHIFT"))
        {
          // add to selection selection
            agentSelected[i] = agentSelected[i] || inRange;
        }
        else
        //if(testbed.getKeyState("_CONTROL")) // ** used for camera control
        if(testbed.getKeyState("T"))
        {
          // toggle selection
            if(inRange)
            {
                agentSelected[i] = !agentSelected[i];
            }
        }
        else
        {
          // set new selection set
            agentSelected[i] = inRange;
        }
        if(agentSelected[i])
        {
            selectedAgents.push_back(i);
        }
    }
}

void
cSelectAndMove::handleInputMessage(iTestBed& testbed, const char* keyPressed, bool& messageHandled, bool& moveRequested)
{
    messageHandled = false;
    if(keyPressed[0] != 'd' || keyPressed[1] != '_')
    {
        return;
    }
    if(!strcmp("LMOUSE", keyPressed + 2) && !testbed.getKeyState("_CONTROL")) // ** control plus left mouse is used for camera movement
    {
        if(!_active)
        {
            testbed.getMouseScreenPosition(_startX, _startY);
            _active = true;
        }
        messageHandled = true;
        moveRequested = false;
        return;
    }
    if(!strcmp("RMOUSE", keyPressed + 2) && !_active  && !testbed.getKeyState("_CONTROL")) // ** control plus right mouse is used to toggle full screen
    {
        messageHandled = true;
        moveRequested = true;
        return;
    }
}
